/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import org.eclipse.buildship.ui.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskViewState;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public final class TaskNodeViewerFilter
extends ViewerFilter {
    private final Predicate<TaskNode> taskNodePredicate;
    private final Predicate<TaskGroupNode> taskGroupNodePredicate;

    private TaskNodeViewerFilter(Predicate<TaskNode> taskNodePredicate, Predicate<TaskGroupNode> taskGroupNodePredicate) {
        this.taskNodePredicate = taskNodePredicate;
        this.taskGroupNodePredicate = taskGroupNodePredicate;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof TaskNode) {
            TaskNode taskNode = (TaskNode)element;
            return this.taskNodePredicate.apply((Object)taskNode);
        }
        if (element instanceof TaskGroupNode) {
            TaskGroupNode taskGroupNode = (TaskGroupNode)element;
            return this.taskGroupNodePredicate.apply((Object)taskGroupNode);
        }
        return true;
    }

    public static ViewerFilter createFor(TaskViewState state) {
        Predicate<TaskNode> taskNodeFilter = TaskNodeViewerFilter.createTaskNodeFilter(state);
        Predicate<TaskGroupNode> taskGroupNodeFilter = TaskNodeViewerFilter.createGroupTaskNodeFiter(taskNodeFilter);
        return new TaskNodeViewerFilter(taskNodeFilter, taskGroupNodeFilter);
    }

    private static Predicate<TaskNode> createTaskNodeFilter(final TaskViewState state) {
        Predicate<TaskNode> projectTasks = new Predicate<TaskNode>(){

            public boolean apply(TaskNode taskNode) {
                return state.isProjectTasksVisible() && taskNode.getType() == TaskNode.TaskNodeType.PROJECT_TASK_NODE;
            }
        };
        Predicate<TaskNode> taskSelectors = new Predicate<TaskNode>(){

            public boolean apply(TaskNode taskNode) {
                return state.isTaskSelectorsVisible() && taskNode.getType() == TaskNode.TaskNodeType.TASK_SELECTOR_NODE;
            }
        };
        Predicate<TaskNode> privateTasks = new Predicate<TaskNode>(){

            public boolean apply(TaskNode taskNode) {
                return state.isPrivateTasksVisible() || taskNode.isPublic();
            }
        };
        return Predicates.and((Predicate)Predicates.or((Predicate)projectTasks, (Predicate)taskSelectors), (Predicate)privateTasks);
    }

    private static Predicate<TaskGroupNode> createGroupTaskNodeFiter(final Predicate<TaskNode> taskNodeFilter) {
        return new Predicate<TaskGroupNode>(){

            public boolean apply(TaskGroupNode taskGroupNode) {
                return !FluentIterable.from(taskGroupNode.getTaskNodes()).filter(taskNodeFilter).toList().isEmpty();
            }
        };
    }
}

