/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.collect.Ordering;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import java.util.Comparator;
import org.eclipse.buildship.ui.view.task.FaultyProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskViewState;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public final class TaskNodeViewerSorter
extends ViewerComparator {
    private final Ordering<ProjectNode> projectNodeOrdering;
    private final Ordering<TaskNode> taskNodeOrdering;
    private final Ordering<FaultyProjectNode> faultyProjectOrdering;

    private TaskNodeViewerSorter(Ordering<ProjectNode> projectNodeOrdering, Ordering<TaskNode> taskNodeOrdering) {
        this.projectNodeOrdering = projectNodeOrdering;
        this.taskNodeOrdering = taskNodeOrdering;
        this.faultyProjectOrdering = TaskNodeViewerSorter.createLexicographicalFaultyProjectOrdering();
    }

    public int compare(Viewer viewer, Object leftNode, Object rightNode) {
        if (leftNode instanceof ProjectNode && rightNode instanceof ProjectNode) {
            ProjectNode left = (ProjectNode)leftNode;
            ProjectNode right = (ProjectNode)rightNode;
            return this.projectNodeOrdering.compare((Object)left, (Object)right);
        }
        if (leftNode instanceof ProjectNode && rightNode instanceof TaskNode) {
            return -1;
        }
        if (leftNode instanceof TaskNode && rightNode instanceof ProjectNode) {
            return 1;
        }
        if (leftNode instanceof TaskNode && rightNode instanceof TaskNode) {
            TaskNode left = (TaskNode)leftNode;
            TaskNode right = (TaskNode)rightNode;
            return this.taskNodeOrdering.compare((Object)left, (Object)right);
        }
        if (leftNode instanceof FaultyProjectNode && rightNode instanceof ProjectNode) {
            return 1;
        }
        if (leftNode instanceof ProjectNode && rightNode instanceof FaultyProjectNode) {
            return -1;
        }
        if (leftNode instanceof FaultyProjectNode && rightNode instanceof FaultyProjectNode) {
            FaultyProjectNode left = (FaultyProjectNode)leftNode;
            FaultyProjectNode right = (FaultyProjectNode)rightNode;
            return this.faultyProjectOrdering.compare((Object)left, (Object)right);
        }
        return super.compare(viewer, leftNode, rightNode);
    }

    public static TaskNodeViewerSorter createFor(TaskViewState state) {
        Ordering<ProjectNode> projectOrdering = TaskNodeViewerSorter.createProjectNodeOrdering();
        Ordering<TaskNode> taskOrdering = TaskNodeViewerSorter.createTaskNodeOrdering(state.isSortByType(), state.isSortByVisibility());
        return new TaskNodeViewerSorter(projectOrdering, taskOrdering);
    }

    private static Ordering<ProjectNode> createProjectNodeOrdering() {
        return new Ordering<ProjectNode>(){

            public int compare(ProjectNode left, ProjectNode right) {
                OmniEclipseProject rightRoot;
                OmniEclipseProject leftRoot = left.getEclipseProject().getRoot();
                if (leftRoot == (rightRoot = right.getEclipseProject().getRoot())) {
                    return 0;
                }
                return leftRoot.getName().compareTo(rightRoot.getName());
            }
        };
    }

    private static Ordering<TaskNode> createTaskNodeOrdering(boolean byType, boolean byVisibility) {
        Ordering ord = TaskNodeViewerSorter.createLexicographicalTaskOrdering();
        if (byVisibility) {
            ord = TaskNodeViewerSorter.createByVisibilityOrdering().compound(ord);
        }
        if (byType) {
            ord = TaskNodeViewerSorter.createByTypeOrdering().compound((Comparator)ord);
        }
        return ord;
    }

    private static Ordering<TaskNode> createLexicographicalTaskOrdering() {
        return new Ordering<TaskNode>(){

            public int compare(TaskNode left, TaskNode right) {
                return left.getName().compareTo(right.getName());
            }
        };
    }

    private static Ordering<FaultyProjectNode> createLexicographicalFaultyProjectOrdering() {
        return new Ordering<FaultyProjectNode>(){

            public int compare(FaultyProjectNode left, FaultyProjectNode right) {
                return ((IProject)left.getWorkspaceProject().get()).getName().compareTo(((IProject)right.getWorkspaceProject().get()).getName());
            }
        };
    }

    private static Ordering<TaskNode> createByVisibilityOrdering() {
        return new Ordering<TaskNode>(){

            public int compare(TaskNode left, TaskNode right) {
                int rightOrdinal;
                int leftOrdinal = this.toOrdinal(left);
                return leftOrdinal < (rightOrdinal = this.toOrdinal(right)) ? -1 : (leftOrdinal == rightOrdinal ? 0 : 1);
            }

            private int toOrdinal(TaskNode node) {
                return node.isPublic() ? 1 : 2;
            }
        };
    }

    private static Ordering<TaskNode> createByTypeOrdering() {
        return new Ordering<TaskNode>(){

            public int compare(TaskNode left, TaskNode right) {
                int rightOrdinal;
                int leftOrdinal = this.toOrdinal(left.getType());
                return leftOrdinal < (rightOrdinal = this.toOrdinal(right.getType())) ? -1 : (leftOrdinal == rightOrdinal ? 0 : 1);
            }

            private int toOrdinal(TaskNode.TaskNodeType type) {
                return type == TaskNode.TaskNodeType.PROJECT_TASK_NODE ? 1 : 2;
            }
        };
    }
}

