/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.workspace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.util.collections.AdapterFunction;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public final class ProjectSynchronizer {
    public static void execute(ExecutionEvent event) {
        Set<IProject> selectedProjects = ProjectSynchronizer.collectSelectedProjects(event);
        if (selectedProjects.isEmpty()) {
            return;
        }
        CorePlugin.gradleWorkspaceManager().getCompositeBuild(selectedProjects).synchronize(NewProjectHandler.IMPORT_AND_MERGE);
    }

    private static Set<IProject> collectSelectedProjects(ExecutionEvent event) {
        IEditorInput editorInput;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            return ProjectSynchronizer.collectGradleProjects(selection.toList());
        }
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)editorInput).getFile();
            return ProjectSynchronizer.collectGradleProjects(ImmutableList.of((Object)file));
        }
        return ImmutableSet.of();
    }

    private static Set<IProject> collectGradleProjects(List<?> candidates) {
        LinkedHashSet projects = Sets.newLinkedHashSet();
        AdapterFunction adapterFunction = AdapterFunction.forType(IResource.class);
        for (Object candidate : candidates) {
            IProject project;
            IResource resource = (IResource)adapterFunction.apply(candidate);
            if (resource == null || !GradleProjectNature.isPresentOn((IProject)(project = resource.getProject()))) continue;
            projects.add(project);
        }
        return projects;
    }
}

