/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.preferences;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.WorkspaceConfiguration;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.util.binding.Validators;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.launch.LaunchMessages;
import org.eclipse.buildship.ui.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.util.font.FontUtils;
import org.eclipse.buildship.ui.util.widget.UiBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GradleWorkbenchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final Font defaultFont = FontUtils.getDefaultDialogFont();
    private final UiBuilder.UiBuilderFactory builderFactory = new UiBuilder.UiBuilderFactory(this.defaultFont);
    private final Validator<File> gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)CoreMessages.Preference_Label_GradleUserHome);
    private Text gradleUserHomeText;

    protected Control createContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        page.setLayout((Layout)layout);
        Group gradleUserHomeGroup = this.createGroup(page, CoreMessages.Preference_Label_GradleUserHome + ":");
        this.createGradleUserHomeSelectionControl((Composite)gradleUserHomeGroup);
        this.initFields();
        return page;
    }

    private Group createGroup(Composite parent, String groupName) {
        Group group = new Group(parent, 0);
        group.setText(groupName);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        return group;
    }

    private void createGradleUserHomeSelectionControl(Composite root) {
        this.gradleUserHomeText = this.builderFactory.newText(root).alignFillHorizontal().control();
        this.gradleUserHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                GradleWorkbenchPreferencePage.this.validate();
            }
        });
        Button gradleUserHomeBrowseButton = this.builderFactory.newButton(root).alignLeft().text(UiMessages.Button_Label_Browse).control();
        DirectoryDialogSelectionListener directoryDialogListener = new DirectoryDialogSelectionListener(root.getShell(), (Widget)this.gradleUserHomeText, CoreMessages.Preference_Label_GradleUserHome);
        gradleUserHomeBrowseButton.addSelectionListener((SelectionListener)directoryDialogListener);
    }

    private void validate() {
        String resolvedGradleUserHome = this.getResolvedGradleUserHome();
        File gradleUserHome = (File)FileUtils.getAbsoluteFile((String)resolvedGradleUserHome).orNull();
        Optional error = this.gradleUserHomeValidator.validate((Object)gradleUserHome);
        this.setValid(!error.isPresent());
        this.setErrorMessage((String)error.orNull());
    }

    private String getResolvedGradleUserHome() {
        String gradleUserHomeExpression = Strings.emptyToNull((String)this.gradleUserHomeText.getText());
        String gradleUserHomeResolved = null;
        try {
            gradleUserHomeResolved = ExpressionUtils.decode((String)gradleUserHomeExpression);
        }
        catch (CoreException e) {
            this.setErrorMessage(NLS.bind((String)LaunchMessages.ErrorMessage_CannotResolveExpression_0, (Object)gradleUserHomeExpression));
            this.setValid(false);
        }
        return gradleUserHomeResolved;
    }

    private void initFields() {
        WorkspaceConfiguration config = CorePlugin.workspaceConfigurationManager().loadWorkspaceConfiguration();
        File gradleUserHome = config.getGradleUserHome();
        this.gradleUserHomeText.setText(gradleUserHome == null ? "" : gradleUserHome.getPath());
    }

    public boolean performOk() {
        String gradleUserHome = this.gradleUserHomeText.getText();
        WorkspaceConfiguration config = new WorkspaceConfiguration(gradleUserHome.isEmpty() ? null : new File(gradleUserHome));
        CorePlugin.workspaceConfigurationManager().saveWorkspaceConfiguration(config);
        return super.performOk();
    }

    protected void performDefaults() {
        this.gradleUserHomeText.setText("");
        super.performDefaults();
    }

    public void dispose() {
        this.defaultFont.dispose();
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }
}

