/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.view.execution.ExecutionPageNameLabelProvider;
import org.eclipse.buildship.ui.view.execution.ExecutionViewMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;

public final class FailureDialog
extends Dialog {
    private static final String FAILURE_DETAILS_URL_PREFIX = "org.gradle.api.GradleException: There were failing tests. See the report at: ";
    private final String title;
    private final ImmutableList<FailureItem> failureItems;
    private Label operationNameText;
    private Text messageText;
    private Text detailsText;
    private Label urlLabel;
    private Link urlLink;
    private Button backButton;
    private Button nextButton;
    private Button copyButton;
    private Clipboard clipboard;
    private int selectionIndex;

    public FailureDialog(Shell parent, String title, List<FinishEvent> failureEvents) {
        super(parent);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.failureItems = FailureItem.from(failureEvents);
        this.setShellStyle(67696);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData containerGridData = new GridData(4, 4, true, true);
        containerGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        container.setLayoutData((Object)containerGridData);
        container.setLayout((Layout)new GridLayout(5, false));
        Label operationNameLabel = new Label(container, 0);
        operationNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        operationNameLabel.setText(ExecutionViewMessages.Dialog_Failure_Operation_Label);
        this.operationNameText = new Label(container, 0);
        GridData operationNameLayoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.operationNameText.setLayoutData((Object)operationNameLayoutData);
        this.backButton = new Button(container, 0x1800000);
        this.backButton.setToolTipText(ExecutionViewMessages.Dialog_Failure_Back_Tooltip);
        this.backButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.backButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        this.nextButton = new Button(container, 0x1800000);
        this.nextButton.setToolTipText(ExecutionViewMessages.Dialog_Failure_Next_Tooltip);
        this.nextButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.nextButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        this.copyButton = new Button(container, 0x1800000);
        this.copyButton.setToolTipText(ExecutionViewMessages.Dialog_Failure_Copy_Details_Tooltip);
        this.copyButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.copyButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        Label messageLabel = new Label(container, 0);
        messageLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        messageLabel.setText(ExecutionViewMessages.Dialog_Failure_Message_Label);
        this.messageText = new Text(container, 2048);
        GridData messageTextLayoutData = new GridData(4, 0x1000000, true, false, 4, 1);
        this.messageText.setLayoutData((Object)messageTextLayoutData);
        this.messageText.setEditable(false);
        Label detailsLabel = new Label(container, 0);
        detailsLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        detailsLabel.setText(ExecutionViewMessages.Dialog_Failure_Details_Label);
        this.detailsText = new Text(container, 2816);
        GridData detailsTextGridData = new GridData(4, 4, true, true, 4, 1);
        detailsTextGridData.heightHint = 200;
        this.detailsText.setLayoutData((Object)detailsTextGridData);
        this.detailsText.setEditable(false);
        this.urlLabel = new Label(container, 0);
        this.urlLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.urlLabel.setText(ExecutionViewMessages.Dialog_Failure_Link_Label);
        this.urlLink = new Link(container, 0);
        this.urlLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.clipboard = new Clipboard(parent.getDisplay());
        this.initSelectionIndex();
        this.initEventListeners();
        this.update();
        return container;
    }

    private void initSelectionIndex() {
        this.selectionIndex = this.failureItems.isEmpty() ? -1 : 0;
    }

    private void initEventListeners() {
        this.backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FailureDialog.this.selectionIndex--;
                FailureDialog.this.update();
            }
        });
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FailureDialog.this.selectionIndex++;
                FailureDialog.this.update();
            }
        });
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] data = new Object[]{FailureDialog.this.detailsText.getText()};
                Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
                FailureDialog.this.clipboard.setContents(data, dataTypes);
            }
        });
        this.urlLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String url = (String)FailureDialog.this.urlLink.getData();
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(32, url, null, url);
                    browser.openURL(URI.create(url).toURL());
                    FailureDialog.this.close();
                }
                catch (Exception e) {
                    throw new GradlePluginsRuntimeException(String.format("Cannot open browser editor for %s.", url), (Throwable)e);
                }
            }
        });
    }

    private void update() {
        Optional failureItem = this.selectionIndex == -1 ? Optional.absent() : Optional.of((Object)this.failureItems.get(this.selectionIndex));
        Optional failure = failureItem.isPresent() ? ((FailureItem)failureItem.get()).failure : Optional.absent();
        this.operationNameText.setText(failureItem.isPresent() ? ExecutionPageNameLabelProvider.renderVerbose(((FailureItem)failureItem.get()).event) : "");
        this.messageText.setText(failure.isPresent() ? Strings.nullToEmpty((String)((Failure)failure.get()).getMessage()) : "");
        this.messageText.setEnabled(failureItem.isPresent());
        this.detailsText.setText(failure.isPresent() ? this.collectDetails((Failure)failure.get()) : "");
        this.detailsText.setEnabled(failureItem.isPresent());
        this.backButton.setEnabled(this.selectionIndex > 0);
        this.nextButton.setEnabled(this.selectionIndex < this.failureItems.size() - 1);
        this.copyButton.setEnabled(failureItem.isPresent() && failure.isPresent() && ((Failure)failure.get()).getDescription() != null);
        Optional<String> testReportUrl = this.findTestReportUrl((Optional<Failure>)failure);
        this.urlLabel.setVisible(testReportUrl.isPresent());
        this.urlLink.setVisible(testReportUrl.isPresent());
        this.urlLink.setText(testReportUrl.isPresent() ? "<a>Test Summary</a>" : "");
        this.urlLink.setData(testReportUrl.isPresent() ? testReportUrl.get() : null);
        this.operationNameText.getParent().layout(true);
    }

    private Optional<String> findTestReportUrl(Optional<Failure> failure) {
        String description;
        int beginIndex;
        if (failure.isPresent() && (beginIndex = (description = ((Failure)failure.get()).getDescription()).indexOf(FAILURE_DETAILS_URL_PREFIX)) >= 0) {
            int endIndex = description.indexOf(10, beginIndex);
            String url = description.substring(beginIndex + FAILURE_DETAILS_URL_PREFIX.length(), endIndex);
            return Optional.of((Object)url);
        }
        return Optional.absent();
    }

    private String collectDetails(Failure failure) {
        return this.collectDetailsRecursively(failure);
    }

    private String collectDetailsRecursively(Failure failure) {
        StringBuilder result = new StringBuilder();
        result.append(Strings.nullToEmpty((String)failure.getDescription()));
        List causes = failure.getCauses();
        if (!causes.isEmpty()) {
            result.append('\n').append(ExecutionViewMessages.Dialog_Failure_Root_Cause_Label).append(' ');
            for (Failure cause : causes) {
                result.append(this.collectDetailsRecursively(cause));
            }
        }
        return result.toString();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, false);
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        return super.close();
    }

    private static final class FailureItem {
        private final FinishEvent event;
        private final Optional<Failure> failure;

        private FailureItem(FinishEvent event, Optional<Failure> failure) {
            this.event = event;
            this.failure = failure;
        }

        private static ImmutableList<FailureItem> from(final FinishEvent event) {
            List failures = ((FailureResult)event.getResult()).getFailures();
            ImmutableList failureItems = FluentIterable.from((Iterable)failures).transform((Function)new Function<Failure, FailureItem>(){

                public FailureItem apply(Failure failure) {
                    return new FailureItem(event, Optional.of((Object)failure));
                }
            }).toList();
            return failureItems.isEmpty() ? ImmutableList.of((Object)new FailureItem(event, (Optional<Failure>)Optional.absent())) : failureItems;
        }

        private static ImmutableList<FailureItem> from(List<FinishEvent> events) {
            ImmutableList.Builder failureItems = ImmutableList.builder();
            for (FinishEvent event : events) {
                failureItems.addAll(FailureItem.from(event));
            }
            return failureItems.build();
        }
    }
}

