/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.gradle.api.JavaVersion;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.impldep.org.apache.commons.lang.reflect.MethodUtils;
import org.gradle.internal.reflect.ClassInspector;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.NoSuchMethodException;
import org.gradle.internal.reflect.NoSuchPropertyException;
import org.gradle.internal.reflect.PropertyAccessor;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.PropertyMutator;
import org.gradle.internal.reflect.ReflectionCache;
import org.gradle.util.CollectionUtils;

public class JavaReflectionUtil {
    private static final WeakHashMap<Class<?>, Set<String>> PROPERTY_CACHE = new WeakHashMap();

    public static <T, F> PropertyAccessor<T, F> readableProperty(Class<T> target, Class<F> returnType, String property) throws NoSuchPropertyException {
        Method getterMethod = JavaReflectionUtil.findGetterMethod(target, property);
        if (getterMethod == null) {
            throw new NoSuchPropertyException(String.format("Could not find getter method for property '%s' on class %s.", property, target.getSimpleName()));
        }
        return new GetterMethodBackedPropertyAccessor(property, returnType, getterMethod);
    }

    public static <T, F> PropertyAccessor<T, F> readableProperty(T target, Class<F> returnType, String property) throws NoSuchPropertyException {
        Class<?> targetClass = target.getClass();
        return JavaReflectionUtil.readableProperty(targetClass, returnType, property);
    }

    public static <T, F> PropertyAccessor<T, F> readableField(Class<T> target, Class<F> fieldType, String fieldName) throws NoSuchPropertyException {
        Field field = JavaReflectionUtil.findField(target, fieldName);
        if (field == null) {
            throw new NoSuchPropertyException(String.format("Could not find field '%s' on class %s.", fieldName, target.getSimpleName()));
        }
        return new FieldBackedPropertyAccessor(fieldName, fieldType, field);
    }

    public static <T, F> PropertyAccessor<T, F> readableField(T target, Class<F> fieldType, String fieldName) throws NoSuchPropertyException {
        Class<?> targetClass = target.getClass();
        return JavaReflectionUtil.readableField(targetClass, fieldType, fieldName);
    }

    private static Method findGetterMethod(Class<?> target, String property) {
        Method[] methods = target.getMethods();
        String getter = JavaReflectionUtil.toMethodName("get", property);
        String iser = JavaReflectionUtil.toMethodName("is", property);
        for (Method method : methods) {
            String methodName = method.getName();
            if (getter.equals(methodName) && PropertyAccessorType.of(method) == PropertyAccessorType.GET_GETTER) {
                return method;
            }
            if (!iser.equals(methodName) || PropertyAccessorType.of(method) != PropertyAccessorType.IS_GETTER) continue;
            return method;
        }
        return null;
    }

    public static PropertyMutator writeableProperty(Class<?> target, String property, @Nullable Class<?> valueType) throws NoSuchPropertyException {
        PropertyMutator mutator = JavaReflectionUtil.writeablePropertyIfExists(target, property, valueType);
        if (mutator != null) {
            return mutator;
        }
        throw new NoSuchPropertyException(String.format("Could not find setter method for property '%s' %s on class %s.", property, valueType == null ? "accepting null value" : "of type " + valueType.getSimpleName(), target.getSimpleName()));
    }

    public static PropertyMutator writeablePropertyIfExists(Class<?> target, String property, @Nullable Class<?> valueType) throws NoSuchPropertyException {
        String setterName = JavaReflectionUtil.toMethodName("set", property);
        Method method = MethodUtils.getMatchingAccessibleMethod(target, setterName, new Class[]{valueType});
        if (method != null) {
            return new MethodBackedPropertyMutator(property, method);
        }
        return null;
    }

    public static PropertyMutator writeableField(Class<?> target, String fieldName) throws NoSuchPropertyException {
        Field field = JavaReflectionUtil.findField(target, fieldName);
        if (field != null) {
            return new FieldBackedPropertyMutator(fieldName, field);
        }
        throw new NoSuchPropertyException(String.format("Could not find writeable field '%s' on class %s.", fieldName, target.getSimpleName()));
    }

    private static Field findField(Class<?> target, String fieldName) {
        Field[] fields;
        for (Field field : fields = target.getFields()) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    private static String toMethodName(String prefix, String propertyName) {
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static Class<?> getWrapperTypeForPrimitiveType(Class<?> type) {
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException(String.format("Don't know the wrapper type for primitive type %s.", type));
    }

    public static <T, R> JavaMethod<T, R> method(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        return new JavaMethod<T, R>(target, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> staticMethod(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        return new JavaMethod<T, R>(target, returnType, name, true, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> method(T target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        Class<?> targetClass = target.getClass();
        return JavaReflectionUtil.method(targetClass, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> method(Class<R> returnType, Method method) throws NoSuchMethodException {
        return new JavaMethod(returnType, method);
    }

    public static Method findMethod(Class<?> target, Spec<Method> predicate) {
        List<Method> methods = JavaReflectionUtil.findAllMethodsInternal(target, predicate, new MultiMap<String, Method>(), new ArrayList<Method>(1), true);
        return methods.isEmpty() ? null : methods.get(0);
    }

    public static List<Method> findAllMethods(Class<?> target, Spec<Method> predicate) {
        return JavaReflectionUtil.findAllMethodsInternal(target, predicate, new MultiMap<String, Method>(), new ArrayList<Method>(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> propertyNames(Object target) {
        Class<?> targetType = target.getClass();
        WeakHashMap<Class<?>, Set<String>> weakHashMap = PROPERTY_CACHE;
        synchronized (weakHashMap) {
            Set<String> cached = PROPERTY_CACHE.get(targetType);
            if (cached == null) {
                cached = ClassInspector.inspect(targetType).getPropertyNames();
                PROPERTY_CACHE.put(targetType, cached);
            }
            return cached;
        }
    }

    public static <T> T newInstanceOrFallback(String jdk7Type, ClassLoader loader, Class<? extends T> fallbackType) {
        Class<Object> handlerClass = null;
        if (JavaVersion.current().isJava7Compatible()) {
            try {
                handlerClass = loader.loadClass(jdk7Type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (handlerClass == null) {
            handlerClass = fallbackType;
        }
        try {
            return Cast.uncheckedCast(handlerClass.newInstance());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private static List<Method> findAllMethodsInternal(Class<?> target, Spec<Method> predicate, MultiMap<String, Method> seen, List<Method> collector, boolean stopAtFirst) {
        for (final Method method : target.getDeclaredMethods()) {
            Object seenWithName = seen.get(method.getName());
            Method override = CollectionUtils.findFirst(seenWithName, new Spec<Method>(){

                @Override
                public boolean isSatisfiedBy(Method potentionOverride) {
                    return potentionOverride.getName().equals(method.getName()) && Arrays.equals(potentionOverride.getParameterTypes(), method.getParameterTypes());
                }
            });
            if (override != null) continue;
            seenWithName.add(method);
            if (!predicate.isSatisfiedBy(method)) continue;
            collector.add(method);
            if (!stopAtFirst) continue;
            return collector;
        }
        Class<?> parent = target.getSuperclass();
        if (parent != null) {
            return JavaReflectionUtil.findAllMethodsInternal(parent, predicate, seen, collector, stopAtFirst);
        }
        return collector;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType) {
        return JavaReflectionUtil.getAnnotation(type, annotationType, true);
    }

    private static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType, boolean checkType) {
        A annotation;
        if (checkType && (annotation = type.getAnnotation(annotationType)) != null) {
            return annotation;
        }
        if (annotationType.getAnnotation(Inherited.class) != null) {
            for (Class<?> anInterface : type.getInterfaces()) {
                annotation = JavaReflectionUtil.getAnnotation(anInterface, annotationType, true);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if (type.isInterface() || type.equals(Object.class)) {
            return null;
        }
        return JavaReflectionUtil.getAnnotation(type.getSuperclass(), annotationType, false);
    }

    public static boolean hasDefaultToString(Object object) {
        try {
            return object.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class;
        }
        catch (java.lang.NoSuchMethodException e) {
            throw new UncheckedException(e);
        }
    }

    public static class CachedConstructor
    extends ReflectionCache.CachedInvokable<Constructor<?>> {
        public CachedConstructor(Constructor<?> ctor) {
            super(ctor);
        }
    }

    private static class FieldBackedPropertyAccessor<T, F>
    implements PropertyAccessor<T, F> {
        private final String property;
        private final Field field;
        private final Class<F> fieldType;

        FieldBackedPropertyAccessor(String property, Class<F> fieldType, Field field) {
            this.property = property;
            this.field = field;
            this.fieldType = fieldType;
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<F> getType() {
            return this.fieldType;
        }

        @Override
        public F getValue(T target) {
            try {
                return this.fieldType.cast(this.field.get(target));
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    private static class FieldBackedPropertyMutator
    implements PropertyMutator {
        private final String name;
        private final Field field;

        FieldBackedPropertyMutator(String name, Field field) {
            this.name = name;
            this.field = field;
        }

        public String toString() {
            return "field " + this.field.getDeclaringClass().getSimpleName() + "." + this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public void setValue(Object target, Object value) {
            try {
                this.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    private static class GetterMethodBackedPropertyAccessor<T, F>
    implements PropertyAccessor<T, F> {
        private final String property;
        private final Method method;
        private final Class<F> returnType;

        GetterMethodBackedPropertyAccessor(String property, Class<F> returnType, Method method) {
            this.property = property;
            this.method = method;
            this.returnType = returnType;
        }

        public String toString() {
            return "property " + this.method.getDeclaringClass().getSimpleName() + "." + this.property;
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<F> getType() {
            return this.returnType;
        }

        @Override
        public F getValue(T target) {
            try {
                return this.returnType.cast(this.method.invoke(target, new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.unwrapAndRethrow(e);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    private static class MethodBackedPropertyMutator
    implements PropertyMutator {
        private final String property;
        private final Method method;

        MethodBackedPropertyMutator(String property, Method method) {
            this.property = property;
            this.method = method;
        }

        public String toString() {
            return "property " + this.method.getDeclaringClass().getSimpleName() + "." + this.property;
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<?> getType() {
            return this.method.getParameterTypes()[0];
        }

        @Override
        public void setValue(Object target, Object value) {
            try {
                this.method.invoke(target, value);
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.unwrapAndRethrow(e);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    private static class MultiMap<K, V>
    extends HashMap<K, List<V>> {
        private MultiMap() {
        }

        @Override
        public List<V> get(Object key) {
            if (!this.containsKey(key)) {
                Object keyCast = key;
                this.put(keyCast, new LinkedList());
            }
            return (List)super.get(key);
        }
    }
}

