/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.perfo.ju.testCases.LAB;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.vp.perfo.helpers.PerformanceCriteriaCreationToolHelper;
import org.polarsys.capella.vp.perfo.perfo.TimeConsumption;
import org.polarsys.capella.vp.perfo.perfo.impl.TimeConsumptionImpl;

public abstract class LABPerfoTest
extends BasicTestCase {
    protected AbstractFunction rootAbstractFunction;
    public static final String MODEL_NAME = "PerfoProject";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    protected void setUp() throws Exception {
        Job[] allJobs;
        super.setUp();
        Job[] jobArray = allJobs = Job.getJobManager().find(null);
        int n = allJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if ("Workbench Auto-Save Job".equals(job.getName())) {
                job.cancel();
            }
            ++n2;
        }
        this.rootAbstractFunction = this.getRootAbstractFunction();
    }

    protected AbstractFunction getRootAbstractFunction() {
        CapellaModel model = this.getTestModel(this.getRequiredTestModels().get(0));
        Session session = this.getSession(this.getRequiredTestModels().get(0));
        Project project = model.getProject(session.getTransactionalEditingDomain());
        SystemEngineering eng = (SystemEngineering)project.getOwnedModelRoots().get(0);
        LogicalArchitecture logicalArchi = (LogicalArchitecture)eng.getOwnedArchitectures().get(2);
        FunctionPkg functionPkg = logicalArchi.getOwnedFunctionPkg();
        return (AbstractFunction)FunctionPkgExt.getOwnedFunctions((FunctionPkg)functionPkg).get(0);
    }

    protected void addTimeCapacity(final EObject element) {
        ExecutionManager manager = TransactionHelper.getExecutionManager((EObject)element);
        manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                PerformanceCriteriaCreationToolHelper perfoCreationToolHelper = new PerformanceCriteriaCreationToolHelper();
                perfoCreationToolHelper.createTimeCapacity(element);
            }
        });
    }

    protected void addTimeConsumption(final EObject element, final int perfoValue) {
        ExecutionManager manager = TransactionHelper.getExecutionManager((EObject)element);
        manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                PerformanceCriteriaCreationToolHelper perfoCreationToolHelper = new PerformanceCriteriaCreationToolHelper();
                perfoCreationToolHelper.createTimeConsumption(element);
                if (element instanceof AbstractFunction) {
                    TimeConsumption elementTimeConsumption = (TimeConsumption)((AbstractFunction)element).getOwnedExtensions().get(0);
                    elementTimeConsumption.setValue(perfoValue);
                } else if (element instanceof FunctionalExchange) {
                    TimeConsumption elementTimeConsumption = (TimeConsumption)((FunctionalExchange)element).getOwnedExtensions().get(0);
                    elementTimeConsumption.setValue(perfoValue);
                }
            }
        });
    }

    protected void editPerfoLogicalFunction(LogicalFunction element, final int newPerfo) {
        final TimeConsumptionImpl pfTimeConsumption = (TimeConsumptionImpl)element.getOwnedExtensions().get(0);
        ExecutionManager managerpc = TransactionHelper.getExecutionManager((EObject)element);
        managerpc.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                pfTimeConsumption.setValue(newPerfo);
            }
        });
    }

    protected void editPerfoFunctionalExchange(FunctionalExchange element, final int newPerfo) {
        final TimeConsumptionImpl feTimeConsumption = (TimeConsumptionImpl)element.getOwnedExtensions().get(0);
        ExecutionManager managerpc = TransactionHelper.getExecutionManager((EObject)element);
        managerpc.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                feTimeConsumption.setValue(newPerfo);
            }
        });
    }
}

