/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.information.communication;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CommunicationLinkKind implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    PRODUCE(1, "PRODUCE", "PRODUCE"),
    CONSUME(2, "CONSUME", "CONSUME"),
    SEND(3, "SEND", "SEND"),
    RECEIVE(4, "RECEIVE", "RECEIVE"),
    CALL(5, "CALL", "CALL"),
    EXECUTE(6, "EXECUTE", "EXECUTE"),
    WRITE(7, "WRITE", "WRITE"),
    ACCESS(8, "ACCESS", "ACCESS"),
    ACQUIRE(9, "ACQUIRE", "ACQUIRE"),
    TRANSMIT(10, "TRANSMIT", "TRANSMIT");

    public static final int UNSET_VALUE = 0;
    public static final int PRODUCE_VALUE = 1;
    public static final int CONSUME_VALUE = 2;
    public static final int SEND_VALUE = 3;
    public static final int RECEIVE_VALUE = 4;
    public static final int CALL_VALUE = 5;
    public static final int EXECUTE_VALUE = 6;
    public static final int WRITE_VALUE = 7;
    public static final int ACCESS_VALUE = 8;
    public static final int ACQUIRE_VALUE = 9;
    public static final int TRANSMIT_VALUE = 10;
    private static final CommunicationLinkKind[] VALUES_ARRAY;
    public static final List<CommunicationLinkKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CommunicationLinkKind[]{UNSET, PRODUCE, CONSUME, SEND, RECEIVE, CALL, EXECUTE, WRITE, ACCESS, ACQUIRE, TRANSMIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CommunicationLinkKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommunicationLinkKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommunicationLinkKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommunicationLinkKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommunicationLinkKind get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return PRODUCE;
            }
            case 2: {
                return CONSUME;
            }
            case 3: {
                return SEND;
            }
            case 4: {
                return RECEIVE;
            }
            case 5: {
                return CALL;
            }
            case 6: {
                return EXECUTE;
            }
            case 7: {
                return WRITE;
            }
            case 8: {
                return ACCESS;
            }
            case 9: {
                return ACQUIRE;
            }
            case 10: {
                return TRANSMIT;
            }
        }
        return null;
    }

    private CommunicationLinkKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

