/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.information.datatype.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polarsys.capella.core.semantic.data.information.datatype.BooleanType;
import org.polarsys.capella.core.semantic.data.information.datatype.DatatypeFactory;
import org.polarsys.capella.core.semantic.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.semantic.data.information.datatype.Enumeration;
import org.polarsys.capella.core.semantic.data.information.datatype.NumericType;
import org.polarsys.capella.core.semantic.data.information.datatype.NumericTypeKind;
import org.polarsys.capella.core.semantic.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.semantic.data.information.datatype.StringType;
import org.polarsys.capella.core.semantic.data.information.datatype.impl.BooleanTypeImpl;
import org.polarsys.capella.core.semantic.data.information.datatype.impl.EnumerationImpl;
import org.polarsys.capella.core.semantic.data.information.datatype.impl.NumericTypeImpl;
import org.polarsys.capella.core.semantic.data.information.datatype.impl.PhysicalQuantityImpl;
import org.polarsys.capella.core.semantic.data.information.datatype.impl.StringTypeImpl;

public class DatatypeFactoryImpl
extends EFactoryImpl
implements DatatypeFactory {
    public static DatatypeFactory init() {
        try {
            DatatypeFactory theDatatypeFactory = (DatatypeFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/capella/core/information/datatype/0.8.0/semantic");
            if (theDatatypeFactory != null) {
                return theDatatypeFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DatatypeFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createBooleanType();
            }
            case 2: {
                return this.createEnumeration();
            }
            case 3: {
                return this.createStringType();
            }
            case 4: {
                return this.createNumericType();
            }
            case 5: {
                return this.createPhysicalQuantity();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createNumericTypeKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertNumericTypeKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public BooleanType createBooleanType() {
        BooleanTypeImpl booleanType = new BooleanTypeImpl();
        return booleanType;
    }

    @Override
    public Enumeration createEnumeration() {
        EnumerationImpl enumeration = new EnumerationImpl();
        return enumeration;
    }

    @Override
    public StringType createStringType() {
        StringTypeImpl stringType = new StringTypeImpl();
        return stringType;
    }

    @Override
    public NumericType createNumericType() {
        NumericTypeImpl numericType = new NumericTypeImpl();
        return numericType;
    }

    @Override
    public PhysicalQuantity createPhysicalQuantity() {
        PhysicalQuantityImpl physicalQuantity = new PhysicalQuantityImpl();
        return physicalQuantity;
    }

    public NumericTypeKind createNumericTypeKindFromString(EDataType eDataType, String initialValue) {
        NumericTypeKind result = NumericTypeKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertNumericTypeKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public DatatypePackage getDatatypePackage() {
        return (DatatypePackage)this.getEPackage();
    }

    @Deprecated
    public static DatatypePackage getPackage() {
        return DatatypePackage.eINSTANCE;
    }
}

