/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.extraction;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimeVersion;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.importer.ecore.EcoreImporter;
import org.polarsys.capella.xmlpivot.common.CapellaPackageRegistry;
import org.polarsys.capella.xmlpivot.extraction.ConceptualMapping;
import org.polarsys.capella.xmlpivot.extraction.DynamicConceptualMapping;
import org.polarsys.capella.xmlpivot.report.RClass;
import org.polarsys.capella.xmlpivot.report.RStructuralFeature;
import org.polarsys.capella.xmlpivot.report.Report;
import org.polarsys.capella.xmlpivot.report.ReportFactory;

public class XMLPivotExtractor {
    private final String projectName;
    private final String genmodelName;
    private final String reportModelName;
    private final String genmodelBasePackage;
    private final String modelPluginClass;
    private final String editPluginClass;
    private final String editorPluginClass;
    private final Collection<EPackage> sourcePackages;
    private final String pluginVersion;
    private final EPackage.Registry registry;

    private XMLPivotExtractor(Builder builder) {
        this.projectName = builder.projectName;
        this.genmodelName = builder.genmodelName;
        this.reportModelName = builder.reportModelName;
        this.genmodelBasePackage = builder.genmodelBasePackage;
        this.modelPluginClass = builder.modelPluginClass;
        this.editPluginClass = builder.editPluginClass;
        this.editorPluginClass = builder.editorPluginClass;
        this.sourcePackages = builder.sourcePackages;
        this.pluginVersion = builder.pluginVersion;
        if (builder.bootstrap) {
            this.registry = new EPackageRegistryImpl();
            this.registry.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        } else {
            this.registry = EPackage.Registry.INSTANCE;
        }
    }

    public void extract() throws Exception {
        if (ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName).exists()) {
            throw new CoreException((IStatus)new Status(4, "org.polarsys.capella.xmlpivot.cli", "Project '" + this.projectName + "' already exists"));
        }
        this.createEMFProject(this.projectName);
        ConceptualMapping mapping = DynamicConceptualMapping.create(this.registry, this.sourcePackages);
        ResourceSetImpl set = new ResourceSetImpl();
        URI destination = URI.createPlatformResourceURI((String)("/" + this.projectName + "/model"), (boolean)true);
        StringBuilder genModelBuilder = new StringBuilder();
        for (String nsURI : this.registry.keySet()) {
            EPackage pack = this.registry.getEPackage(nsURI);
            if (pack == EcorePackage.eINSTANCE || pack.getESuperPackage() != null) continue;
            Iterator resource = set.createResource(destination.appendSegment(String.valueOf(pack.getName()) + ".ecore"));
            resource.getContents().add((Object)pack);
            genModelBuilder.append(String.valueOf(resource.getURI().toString()) + "\n");
        }
        Report report = XMLPivotExtractor.fromConceptualMapping(this.sourcePackages, mapping);
        Resource reportResource = set.createResource(destination.appendSegment(this.reportModelName));
        reportResource.getContents().add((Object)report);
        for (Resource res : set.getResources()) {
            res.save(Collections.EMPTY_MAP);
        }
        EcoreImporter importer = new EcoreImporter(){

            protected void presetEPackagesToGenerate() {
                for (EPackage p : this.getEPackages()) {
                    this.getEPackageImportInfo(p).setConvert(true);
                    this.getEPackageImportInfo(p).setBasePackage(XMLPivotExtractor.this.genmodelBasePackage);
                }
            }
        };
        BasicMonitor m = new BasicMonitor();
        importer.setModelLocation(genModelBuilder.toString());
        importer.setGenModelFileName(this.genmodelName);
        importer.setGenModelProjectLocation((IPath)new Path(destination.segment(1)));
        importer.setGenModelContainerPath((IPath)new Path(String.valueOf(destination.toPlatformString(true)) + "/"));
        try {
            importer.computeEPackages((Monitor)m);
        }
        catch (Exception exception_p) {
            throw new InvocationTargetException(exception_p);
        }
        importer.adjustEPackages((Monitor)m);
        importer.prepareGenModelAndEPackages((Monitor)m);
        importer.getGenModel().setComplianceLevel(GenJDKLevel.JDK50_LITERAL);
        importer.getGenModel().setRuntimeVersion(GenRuntimeVersion.EMF26);
        importer.getGenModel().setModelPluginClass(this.modelPluginClass);
        importer.getGenModel().setEditPluginClass(this.editPluginClass);
        importer.getGenModel().setEditorPluginClass(this.editorPluginClass);
        this.customizeImporter(importer);
        importer.saveGenModelAndEPackages((Monitor)m);
    }

    protected void customizeImporter(EcoreImporter importer) {
    }

    private void createEMFProject(String name) throws CoreException, UnsupportedEncodingException, IOException {
        Path genmodelContainerPath = new Path("/" + name + "/src");
        Generator.createEMFProject((IPath)genmodelContainerPath, null, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor(), (int)(Generator.EMF_MODEL_PROJECT_STYLE | Generator.EMF_PLUGIN_PROJECT_STYLE));
        CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)new Path("/" + name + "/model"), (boolean)true, null, (IProgressMonitor)new NullProgressMonitor());
        PrintStream manifest = new PrintStream(URIConverter.INSTANCE.createOutputStream(URI.createPlatformResourceURI((String)("/" + name + "/META-INF/MANIFEST.MF"), (boolean)true), null), false, "UTF-8");
        manifest.println("Manifest-Version: 1.0");
        manifest.println("Bundle-ManifestVersion: 2");
        manifest.print("Bundle-Name: ");
        manifest.println(name);
        manifest.print("Bundle-SymbolicName: ");
        manifest.println(CodeGenUtil.validPluginID((String)name));
        manifest.println("Bundle-Version: " + this.pluginVersion);
        manifest.println("Require-Bundle: org.eclipse.emf.ecore");
        manifest.close();
    }

    public static Report fromConceptualMapping(Collection<EPackage> sourcePackages, ConceptualMapping mapping) {
        Report report = ReportFactory.eINSTANCE.createReport();
        for (EPackage eCorePackage : sourcePackages) {
            if (eCorePackage.getESuperPackage() != null) continue;
            TreeIterator it = eCorePackage.eAllContents();
            while (it.hasNext()) {
                RClass element;
                EObject next = (EObject)it.next();
                if (!(next instanceof EModelElement) || mapping.getSimplified((EModelElement)next) != null) continue;
                if (next instanceof EClass) {
                    element = ReportFactory.eINSTANCE.createRClass();
                    element.setModelElement((EModelElement)next);
                    report.getRClasses().add((Object)element);
                    it.prune();
                    continue;
                }
                if (!(next instanceof EStructuralFeature)) continue;
                element = ReportFactory.eINSTANCE.createRStructuralFeature();
                element.setModelElement((EModelElement)next);
                report.getRStructuralFeatures().add((Object)element);
            }
        }
        ECollections.sort((EList)report.getRClasses(), (Comparator)new Comparator<RClass>(){

            @Override
            public int compare(RClass o1_p, RClass o2_p) {
                EClass m1 = (EClass)o1_p.getModelElement();
                EClass m2 = (EClass)o2_p.getModelElement();
                return m1.getName().compareTo(m2.getName());
            }
        });
        ECollections.sort((EList)report.getRStructuralFeatures(), (Comparator)new Comparator<RStructuralFeature>(){

            @Override
            public int compare(RStructuralFeature o1_p, RStructuralFeature o2_p) {
                EStructuralFeature m1 = (EStructuralFeature)o1_p.getModelElement();
                EStructuralFeature m2 = (EStructuralFeature)o2_p.getModelElement();
                return m1.getName().compareTo(m2.getName());
            }
        });
        return report;
    }

    /* synthetic */ XMLPivotExtractor(Builder builder, XMLPivotExtractor xMLPivotExtractor) {
        this(builder);
    }

    public static final class Builder {
        public String projectName = "XMLPivotExtractor";
        public String genmodelName = "simplified.genmodel";
        public String reportModelName = "unmapped.report";
        public String genmodelBasePackage = "org.polarsys.capella.semantic.data";
        public String modelPluginClass = "org.polarsys.capella.semantic.data.capellamodeller.CapellaModellerPlugin";
        public String editPluginClass = "org.polarsys.capella.semantic.data.capellamodeller.provider.CapellamodellerEditPlugin";
        public String editorPluginClass = "org.polarsys.capella.semantic.data.capellamodeller.presentation.CapellamodellerEditorPlugin";
        public String pluginVersion = "0.8.0";
        public Collection<EPackage> sourcePackages = CapellaPackageRegistry.getAllCapellaPackages();
        public boolean bootstrap = false;

        public XMLPivotExtractor build() {
            return new XMLPivotExtractor(this, null);
        }
    }
}

