/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.common.functions;

import com.google.common.base.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EMFFunctions {
    public static Function<Resource, String> resourceToUriString() {
        return new Function<Resource, String>(){

            public String apply(Resource input_p) {
                return input_p.getURI().toString();
            }
        };
    }

    public static final Function<Resource, String> resourceToNormalizedUriString() {
        return new Function<Resource, String>(){

            public String apply(Resource input_p) {
                return input_p.getResourceSet().getURIConverter().normalize(input_p.getURI()).toString();
            }
        };
    }

    public static final Function<EObject, String> eObjectToUriString() {
        return new Function<EObject, String>(){

            public String apply(EObject input_p) {
                URI u = EcoreUtil.getURI((EObject)input_p);
                if (u == null) {
                    return "";
                }
                return u.toString();
            }
        };
    }
}

