/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.common.skeleton;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.epbs.PhysicalArchitectureRealization;
import org.polarsys.capella.core.data.epbs.PhysicalArtifactRealization;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.xmlpivot.common.skeleton.BlockArchitectureWalker;
import org.polarsys.capella.xmlpivot.common.skeleton.ModelWalkerHelper;

public class EPBSArchitectureWalker
extends BlockArchitectureWalker {
    @Override
    public void accept(EObject eObject_p, ModelWalkerHelper helper) {
        super.accept(eObject_p, helper);
        EPBSArchitecture epbs = (EPBSArchitecture)eObject_p;
        if (epbs.getOwnedConfigurationItem() == null) {
            epbs.setOwnedConfigurationItem(helper.getConfigurationItem());
        }
        if (epbs.getOwnedEPBSContext() == null) {
            epbs.setOwnedEPBSContext(helper.getEPBSContext());
        }
        if (epbs.getOwnedAbstractCapabilityPkg() == null) {
            epbs.setOwnedAbstractCapabilityPkg(helper.getAbstractCapabilityPkg((BlockArchitecture)epbs));
        }
        this.createPhysicalArchitectureRealization(epbs);
        this.createPhysicalComponentRealization(epbs);
    }

    private void createPhysicalComponentRealization(EPBSArchitecture epbs) {
        PhysicalArchitecture pa;
        SystemEngineering eng = SystemEngineeringExt.getSystemEngineering((CapellaElement)epbs);
        if (eng != null && (pa = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)eng)) != null) {
            ConfigurationItem ci = epbs.getOwnedConfigurationItem();
            PhysicalComponent pc = pa.getOwnedPhysicalComponent();
            if (ci != null && pc != null) {
                PhysicalArtifactRealization par2;
                for (PhysicalArtifactRealization par2 : ci.getOwnedPhysicalArtifactRealizations()) {
                    if (par2.getSourceElement() != ci || par2.getTargetElement() != pc) continue;
                    return;
                }
                par2 = EpbsFactory.eINSTANCE.createPhysicalArtifactRealization();
                ci.getOwnedPhysicalArtifactRealizations().add((Object)par2);
                par2.setSourceElement((TraceableElement)ci);
                par2.setTargetElement((TraceableElement)pc);
            }
        }
    }

    private void createPhysicalArchitectureRealization(EPBSArchitecture epbs) {
        PhysicalArchitecture pa;
        SystemEngineering se = SystemEngineeringExt.getSystemEngineering((CapellaElement)epbs);
        if (se != null && (pa = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)se)) != null) {
            PhysicalArchitectureRealization par2;
            for (PhysicalArchitectureRealization par2 : epbs.getOwnedPhysicalArchitectureRealizations()) {
                if (par2.getSourceElement() != epbs || par2.getTargetElement() != pa) continue;
                return;
            }
            par2 = EpbsFactory.eINSTANCE.createPhysicalArchitectureRealization();
            epbs.getOwnedPhysicalArchitectureRealizations().add((Object)par2);
            par2.setSourceElement((TraceableElement)epbs);
            par2.setTargetElement((TraceableElement)pa);
        }
    }

    @Override
    protected boolean hasOwnedDataPkg() {
        return false;
    }

    @Override
    protected boolean hasOwnedInterfacePkg() {
        return false;
    }
}

