/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class ConnectionQuery {
    private static final int DEFAULT_INITIAL_TRANSITIVITY_DEPTH = 1;
    private EObject element = null;
    private EObject traceModel = null;
    private boolean reverseDirection = false;
    private List<String> selectedRelationshipTypes = new ArrayList<String>();
    private int transitivityDepth = 1;
    private boolean traverseTransitiveLinks = false;
    private boolean includeInternalLinks = false;

    private ConnectionQuery(Builder builder) {
        this.element = builder.element;
        this.traceModel = builder.traceModel;
        this.reverseDirection = builder.reverseDirection;
        this.selectedRelationshipTypes = builder.selectedRelationshipTypes;
        this.transitivityDepth = builder.transitivityDepth;
        this.traverseTransitiveLinks = builder.traverseTransitiveLinks;
        this.includeInternalLinks = builder.includeInternalLinks;
    }

    public static Builder of(EObject traceModel, EObject element) {
        return new Builder(traceModel, element);
    }

    public EObject getElement() {
        return this.element;
    }

    public EObject getTraceModel() {
        return this.traceModel;
    }

    public boolean isReverseDirection() {
        return this.reverseDirection;
    }

    public List<String> getSelectedRelationshipTypes() {
        return this.selectedRelationshipTypes;
    }

    public int getTransitivityDepth() {
        return this.transitivityDepth;
    }

    public boolean isTraverseTransitiveLinks() {
        return this.traverseTransitiveLinks;
    }

    public boolean isIncludeInternalLinks() {
        return this.includeInternalLinks;
    }

    public static final class Builder {
        private EObject element = null;
        private EObject traceModel = null;
        private boolean reverseDirection = false;
        private List<String> selectedRelationshipTypes = new ArrayList<String>();
        private int transitivityDepth = 1;
        private boolean traverseTransitiveLinks = false;
        private boolean includeInternalLinks = false;

        public ConnectionQuery build() {
            if (this.element == null) {
                throw new IllegalArgumentException("The origin of the connection must be set!");
            }
            if (this.traceModel == null) {
                throw new IllegalArgumentException("The trace model must be set!");
            }
            return new ConnectionQuery(this);
        }

        private Builder(EObject traceModel, EObject element) {
            this.element = element;
            this.traceModel = traceModel;
        }

        public Builder setReverseDirection(boolean reverseDirection) {
            this.reverseDirection = reverseDirection;
            return this;
        }

        public Builder setSelectedRelationshipTypes(List<String> selectedRelationshipTypes) {
            this.selectedRelationshipTypes = selectedRelationshipTypes == null ? new ArrayList<String>() : selectedRelationshipTypes;
            return this;
        }

        public Builder setTransitivityDepth(int transitivityDepth) {
            if (transitivityDepth < 0) {
                throw new IllegalArgumentException("Transitivity depth cannot be negative!");
            }
            this.transitivityDepth = transitivityDepth;
            return this;
        }

        public Builder setTraverseTransitiveLinks(boolean traverseTransitiveLinks) {
            this.traverseTransitiveLinks = traverseTransitiveLinks;
            return this;
        }

        public Builder setIncludeInternalLinks(boolean includeInternalLinks) {
            this.includeInternalLinks = includeInternalLinks;
            return this;
        }
    }
}

