/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.IfObjectIntProcedure;
import org.eclipse.collections.impl.block.procedure.IfProcedure;
import org.eclipse.collections.impl.block.procedure.IfProcedureWith;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.AllSatisfyPredicate;
import org.eclipse.collections.impl.lazy.iterator.SelectInstancesOfIterator;
import org.eclipse.collections.impl.utility.Iterate;

public class SelectInstancesOfIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<?> adapted;
    private final Class<T> clazz;

    public SelectInstancesOfIterable(Iterable<?> newAdapted, Class<T> clazz) {
        this.adapted = newAdapted;
        this.clazz = clazz;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, new IfProcedure<T>(Predicates.instanceOf(this.clazz), procedure));
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEach(this.adapted, new IfObjectIntProcedure<T>(Predicates.instanceOf(this.clazz), objectIntProcedure));
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, new IfProcedureWith<T, P>(Predicates.instanceOf(this.clazz), procedure), parameter);
    }

    @Override
    public T getFirst() {
        return this.clazz.cast(Iterate.detect(this.adapted, Predicates.instanceOf(this.clazz)));
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return Iterate.anySatisfy(this.adapted, Predicates.and(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return Iterate.allSatisfy(this.adapted, new AllSatisfyPredicate<T>(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return Iterate.noneSatisfy(this.adapted, new AllSatisfyPredicate<T>(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return Iterate.detect(this.adapted, Predicates.and(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        return Iterate.detectOptional(this.adapted, Predicates.and(Predicates.instanceOf(this.clazz), predicate));
    }

    @Override
    public Iterator<T> iterator() {
        return new SelectInstancesOfIterator<T>(this.adapted, this.clazz);
    }
}

