/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.scoping.InterfaceUtilities;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.ExecutableSource;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.InterfaceReference;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.TraceSource;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;

public abstract class GeneratorTask {
    protected final List<String> errors;
    protected final Task task;
    protected final Resource resource;
    protected final IScopeProvider scopeProvider;
    protected final IFileSystemAccess2 fsa;
    protected final String projectFileName;
    protected final OutputLocator outputLocator;

    public GeneratorTask(Task task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        this.task = task;
        this.resource = task.eResource();
        this.scopeProvider = scopeProvider;
        this.fsa = fsa;
        ArrayList<String> _arrayList = new ArrayList<String>();
        this.errors = _arrayList;
        this.projectFileName = this.resource.getURI().lastSegment();
        this.outputLocator = outputLocator;
    }

    public List<String> startGeneration() {
        try {
            this.doGenerate();
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException e = (IllegalArgumentException)_t;
                this.errors.add(e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return this.errors;
    }

    protected abstract void doGenerate() throws IllegalArgumentException;

    protected IllegalArgumentException createException(String message) {
        String _lastSegment = this.resource.getURI().lastSegment();
        String _plus = String.valueOf(message) + " - " + _lastSegment;
        String _plus_1 = String.valueOf(_plus) + " (";
        String _simpleName = this.getClass().getSimpleName();
        String _plus_2 = String.valueOf(_plus_1) + _simpleName;
        String _plus_3 = String.valueOf(_plus_2) + ")";
        return new IllegalArgumentException(_plus_3);
    }

    protected IllegalArgumentException createException(String message, Resource context, Class<?> cl) {
        String _lastSegment = context.getURI().lastSegment();
        String _plus = String.valueOf(message) + " - " + _lastSegment;
        String _plus_1 = String.valueOf(_plus) + " (";
        String _simpleName = cl.getSimpleName();
        String _plus_2 = String.valueOf(_plus_1) + _simpleName;
        String _plus_3 = String.valueOf(_plus_2) + ")";
        return new IllegalArgumentException(_plus_3);
    }

    public CommaFileSystemAccess commaFSA() {
        return new CommaFileSystemAccess(this.fsa);
    }

    public CommaFileSystemAccess commaFSA(String root) {
        CommaFileSystemAccess _xblockexpression = null;
        String _xifexpression = null;
        boolean _endsWith = root.endsWith("/");
        boolean _not = !_endsWith;
        _xifexpression = _not ? String.valueOf(root) + "/" : root;
        String path = _xifexpression;
        _xblockexpression = new CommaFileSystemAccess(path, this.fsa);
        return _xblockexpression;
    }

    public Signature getSignature(Interface cInterface) {
        return InterfaceUtilities.getSignature((Interface)cInterface, (IScopeProvider)this.scopeProvider);
    }

    public String getGeneratedFile(Task task) {
        return this.outputLocator.getGeneratedFile(task);
    }

    public String getFileName(Task task) {
        return this.outputLocator.getFileName(task);
    }

    public String getOutputFolder(Task task) {
        return this.outputLocator.getOutputFolder(task);
    }

    public CommaFileSystemAccess getFileSystemAccess(Task task) {
        return this.commaFSA(this.outputLocator.getOutputFolder(task));
    }

    public Resource getTraceResource(TraceSource source) {
        return this.outputLocator.getTraceResource((IFileSystemAccess)this.fsa, source);
    }

    public URI getTraceResourceURI(TraceSource source) {
        return this.outputLocator.getTraceResourceURI((IFileSystemAccess)this.fsa, source);
    }

    protected Interface _getInterface(InterfaceReference iRef) {
        return iRef.getInterface();
    }

    protected Interface _getInterface(ComponentReference iRef) {
        return null;
    }

    public ArrayList<Resource> getResourcesFromDirs(List<FilePath> directories) {
        ArrayList<Resource> _xblockexpression = null;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (FilePath location : directories) {
            URI uri = GeneratorTask.resolveUri(this.resource, location.getPath());
            boolean _isPlatform = uri.isPlatform();
            if (_isPlatform) {
                String platform = uri.toPlatformString(true);
                IResource eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(platform);
                uri = URI.createFileURI((String)eclipseResource.getRawLocation().toOSString());
            }
            FilenameFilter traceFiler = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".traces") || name.endsWith(".events");
                }
            };
            String _fileString = uri.toFileString();
            File dir = new File(_fileString);
            if (dir.exists() && dir.isDirectory()) {
                File[] _listFiles;
                File[] fileArray = _listFiles = dir.listFiles(traceFiler);
                int n = _listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    Resource res = this.resource.getResourceSet().getResource(URI.createFileURI((String)file.getPath()), true);
                    if (res != null) {
                        resources.add(res);
                    } else {
                        String _path = file.getPath();
                        String _plus = "Trace resource could not be loaded: " + _path;
                        String _plus_1 = String.valueOf(_plus) + ".";
                        this.errors.add(_plus_1);
                    }
                    ++n2;
                }
                continue;
            }
            String _path = dir.getPath();
            String _plus = "Trace dir did not exist or is not a directory. " + _path;
            this.errors.add(_plus);
        }
        _xblockexpression = resources;
        return _xblockexpression;
    }

    public static URI resolveUri(Resource context, String path) {
        URI contextURI = context.getURI();
        URI uri = URI.createFileURI((String)path);
        if (contextURI.isHierarchical() && !contextURI.isRelative() && uri.isRelative() && !uri.isEmpty()) {
            uri = uri.resolve(contextURI);
        }
        return uri;
    }

    public Interface getInterface(ExecutableSource iRef) {
        if (iRef instanceof ComponentReference) {
            return this._getInterface((ComponentReference)iRef);
        }
        if (iRef instanceof InterfaceReference) {
            return this._getInterface((InterfaceReference)iRef);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(iRef).toString());
    }
}

