/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.context;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class InputContextManager
implements IResourceChangeListener {
    private PDEFormEditor editor;
    private Hashtable<IEditorInput, Object> inputContexts;
    private ArrayList<IFile> monitoredFiles;
    private ArrayList<IInputContextListener> listeners;
    private IModelUndoManager undoManager;

    public InputContextManager(PDEFormEditor editor) {
        this.editor = editor;
        this.inputContexts = new Hashtable();
        this.listeners = new ArrayList();
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void addInputContextListener(IInputContextListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeInputContextListener(IInputContextListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            this.unhookUndo(context);
            context.dispose();
        }
        this.inputContexts.clear();
        this.undoManager = null;
    }

    public void save(IProgressMonitor monitor) {
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.mustSave()) continue;
            context.doSave(monitor);
        }
    }

    public IProject getCommonProject() {
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            IEditorInput input = context.getInput();
            if (!(input instanceof IFileEditorInput)) continue;
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    public boolean hasContext(String id) {
        return this.findContext(id) != null;
    }

    public InputContext findContext(String id) {
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.getId().equals(id)) continue;
            return context;
        }
        return null;
    }

    public InputContext findContext(IResource resource) {
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.matches(resource)) continue;
            return context;
        }
        return null;
    }

    public abstract IBaseModel getAggregateModel();

    public InputContext getContext(IEditorInput input) {
        return (InputContext)this.inputContexts.get(input);
    }

    public void putContext(IEditorInput input, InputContext context) {
        this.inputContexts.put(input, context);
        this.fireContextChange(context, true);
    }

    private void updateInputContext(IEditorInput newInput, IEditorInput oldInput) throws Exception {
        Object value = null;
        if (!this.inputContexts.containsKey(oldInput)) {
            throw new Exception(PDEUIMessages.InputContextManager_errorMessageInputContextNotFound);
        }
        value = this.inputContexts.remove(oldInput);
        this.inputContexts.put(newInput, value);
    }

    public void saveAs(IProgressMonitor monitor, String contextID) throws Exception {
        InputContext inputContext = this.findContext(contextID);
        if (inputContext == null) {
            throw new Exception(PDEUIMessages.InputContextManager_errorMessageInputContextNotFound);
        }
        IEditorInput oldInput = this.editor.getEditorInput();
        inputContext.doSaveAs(monitor);
        IEditorInput newInput = inputContext.getInput();
        this.updateInputContext(newInput, oldInput);
    }

    public InputContext getPrimaryContext() {
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.isPrimary()) continue;
            return context;
        }
        return null;
    }

    public InputContext[] getInvalidContexts() {
        ArrayList<InputContext> result = new ArrayList<InputContext>();
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (context.isModelCorrect()) continue;
            result.add(context);
        }
        return result.toArray(new InputContext[result.size()]);
    }

    public boolean isDirty() {
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.mustSave()) continue;
            return true;
        }
        return false;
    }

    public void monitorFile(IFile file) {
        if (this.monitoredFiles == null) {
            this.monitoredFiles = new ArrayList();
        }
        this.monitoredFiles.add(file);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept(delta1 -> {
                int kind = delta1.getKind();
                IResource resource = delta1.getResource();
                if (resource instanceof IFile) {
                    if (kind == 1) {
                        this.asyncStructureChanged((IFile)resource, true);
                    } else if (kind == 2) {
                        this.asyncStructureChanged((IFile)resource, false);
                    }
                    return false;
                }
                return true;
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void asyncStructureChanged(IFile file, boolean added) {
        if (this.editor == null || this.editor.getEditorSite() == null) {
            return;
        }
        Shell shell = this.editor.getEditorSite().getShell();
        Display display = shell != null ? shell.getDisplay() : Display.getDefault();
        display.asyncExec(() -> this.structureChanged(file, added));
    }

    protected void structureChanged(IFile file, boolean added) {
        if (this.monitoredFiles == null) {
            return;
        }
        int i = 0;
        while (i < this.monitoredFiles.size()) {
            IFile ifile = this.monitoredFiles.get(i);
            if (ifile.equals((Object)file)) {
                if (added) {
                    this.fireStructureChange(file, true);
                } else {
                    this.fireStructureChange(file, false);
                    this.removeContext(file);
                }
            }
            ++i;
        }
    }

    private void removeContext(IFile file) {
        Enumeration<Object> contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            IFileEditorInput fileInput;
            InputContext context = (InputContext)contexts.nextElement();
            IEditorInput input = context.getInput();
            if (!(input instanceof IFileEditorInput) || !file.equals((Object)(fileInput = (IFileEditorInput)input).getFile())) continue;
            this.inputContexts.remove(input);
            this.fireContextChange(context, false);
            return;
        }
    }

    protected void fireStructureChange(IFile file, boolean added) {
        int i = 0;
        while (i < this.listeners.size()) {
            IInputContextListener listener = this.listeners.get(i);
            if (added) {
                listener.monitoredFileAdded(file);
            } else {
                listener.monitoredFileRemoved(file);
            }
            ++i;
        }
    }

    protected void fireContextChange(InputContext context, boolean added) {
        int i = 0;
        while (i < this.listeners.size()) {
            IInputContextListener listener = this.listeners.get(i);
            if (added) {
                listener.contextAdded(context);
            } else {
                listener.contextRemoved(context);
            }
            ++i;
        }
        if (added) {
            this.hookUndo(context);
        } else {
            this.unhookUndo(context);
        }
    }

    public void undo() {
        if (this.undoManager != null && this.undoManager.isUndoable()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager != null && this.undoManager.isRedoable()) {
            this.undoManager.redo();
        }
    }

    private void hookUndo(InputContext context) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel model = context.getModel();
        if (model instanceof IModelChangeProvider) {
            this.undoManager.connect((IModelChangeProvider)model);
        }
    }

    private void unhookUndo(InputContext context) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel model = context.getModel();
        if (model instanceof IModelChangeProvider) {
            this.undoManager.disconnect((IModelChangeProvider)model);
        }
    }

    public IModelUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(IModelUndoManager undoManager) {
        this.undoManager = undoManager;
    }
}

