/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractNegatedToken;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.util.XtextSwitch;

public class UsedRulesFinder
extends XtextSwitch<Void> {
    private final Collection<AbstractRule> usedRules;
    private final Collection<Grammar> visitedGrammars = Sets.newHashSet();

    public UsedRulesFinder(Collection<AbstractRule> usedRules) {
        this.usedRules = usedRules;
    }

    @Override
    public Void caseAbstractRule(AbstractRule object) {
        this.usedRules.add(object);
        return null;
    }

    @Override
    public Void caseParserRule(ParserRule object) {
        if (this.usedRules.add(object)) {
            if (object.getAlternatives() != null) {
                this.doSwitch(object.getAlternatives());
            }
            if (object.isDefinesHiddenTokens()) {
                for (AbstractRule rule : object.getHiddenTokens()) {
                    this.doSwitch(rule);
                }
            }
        }
        return null;
    }

    @Override
    public Void caseTerminalRule(TerminalRule object) {
        if (this.usedRules.add(object) && object.getAlternatives() != null) {
            return (Void)this.doSwitch(object.getAlternatives());
        }
        return null;
    }

    @Override
    public Void caseAbstractNegatedToken(AbstractNegatedToken object) {
        if (object.getTerminal() != null) {
            return (Void)this.doSwitch(object.getTerminal());
        }
        return null;
    }

    @Override
    public Void caseRuleCall(RuleCall object) {
        if (object.getRule() != null) {
            return (Void)this.doSwitch(object.getRule());
        }
        return null;
    }

    @Override
    public Void caseCrossReference(CrossReference object) {
        if (object.getTerminal() != null) {
            return (Void)this.doSwitch(object.getTerminal());
        }
        return null;
    }

    @Override
    public Void caseAssignment(Assignment object) {
        if (object.getTerminal() != null) {
            return (Void)this.doSwitch(object.getTerminal());
        }
        return null;
    }

    @Override
    public Void caseCompoundElement(CompoundElement object) {
        for (AbstractElement element : object.getElements()) {
            this.doSwitch(element);
        }
        return null;
    }

    @Override
    public Void caseGrammar(Grammar object) {
        if (!this.visitedGrammars.add(object)) {
            return null;
        }
        if (object.isDefinesHiddenTokens()) {
            for (AbstractRule rule : object.getHiddenTokens()) {
                this.doSwitch(rule);
            }
        }
        for (Grammar grammar : object.getUsedGrammars()) {
            this.caseGrammar(grammar);
        }
        return null;
    }

    public void compute(Grammar grammar) {
        AbstractRule firstRule;
        if (!grammar.getRules().isEmpty() && (firstRule = (AbstractRule)grammar.getRules().get(0)) instanceof ParserRule) {
            this.doSwitch(firstRule);
            this.doSwitch(grammar);
        }
    }
}

