/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.diagnostic;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.ITokenDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.SerializationDiagnostic;
import org.eclipse.xtext.util.EmfFormatter;

public class TokenDiagnosticProvider
implements ITokenDiagnosticProvider {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IGrammarAccess grammarAccess;

    protected String getFullReferenceName(EObject semanticObject, CrossReference reference) {
        EReference ref = GrammarUtil.getReference(reference);
        String clazz = semanticObject.eClass().getName();
        if (ref.getEContainingClass() != semanticObject.eClass()) {
            clazz = ref.getEContainingClass().getName() + "(" + clazz + ")";
        }
        return clazz + "." + ref.getName();
    }

    @Override
    public ISerializationDiagnostic getInvalidEnumValueDiagnostic(EObject semanticObject, RuleCall rc, Object value) {
        ArrayList valid = Lists.newArrayList();
        for (EnumLiteralDeclaration eld : EcoreUtil2.getAllContentsOfType(rc.getRule(), EnumLiteralDeclaration.class)) {
            valid.add(eld.getEnumLiteral().getInstance().getName());
        }
        StringBuilder msg = new StringBuilder();
        msg.append("The value '" + value + "' is invalid for enum " + rc.getRule().getName() + "\n");
        msg.append("Valid values are: " + Joiner.on((String)", ").join((Iterable)valid));
        return new SerializationDiagnostic("invalid enum value", semanticObject, rc, this.grammarAccess.getGrammar(), msg.toString());
    }

    @Override
    public ISerializationDiagnostic getNoEObjectDescriptionFoundDiagnostic(EObject semanticObject, CrossReference element, EObject target, IScope scope) {
        String msg = "No EObjectDescription could be found in Scope " + this.getFullReferenceName(semanticObject, element) + " for " + EmfFormatter.objPath((EObject)target);
        return new SerializationDiagnostic("no eobject description found", semanticObject, element, this.grammarAccess.getGrammar(), msg);
    }

    @Override
    public ISerializationDiagnostic getNoScopeFoundDiagnostic(EObject semanticObject, CrossReference element, EObject target) {
        String msg = "Could not create Scope for EReference " + this.getFullReferenceName(semanticObject, element);
        return new SerializationDiagnostic("no scope found", semanticObject, element, this.grammarAccess.getGrammar(), msg);
    }

    @Override
    public ISerializationDiagnostic getNullNotAllowedDiagnostic(EObject semanticObject, AbstractElement ele) {
        return new SerializationDiagnostic("null not allowed", semanticObject, ele, this.grammarAccess.getGrammar(), "Must not be null");
    }

    @Override
    public ISerializationDiagnostic getValueConversionExceptionDiagnostic(EObject semantic, AbstractElement element, Object value, Throwable exception) {
        String ruleName = this.linkingHelper.getRuleNameFrom(element);
        StringBuilder msg = new StringBuilder();
        msg.append("Error while converting value '");
        msg.append(value);
        msg.append("' for grammar rule '");
        msg.append(ruleName);
        msg.append("' to string via ValueConverter.");
        return new SerializationDiagnostic("value conversion exception", semantic, element, this.grammarAccess.getGrammar(), msg.toString(), exception);
    }
}

