/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.petrinet.PTransition;
import org.eclipse.comma.petrinet.Place;
import org.eclipse.comma.petrinet.PythonHelper;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.Parameter;

class Output {
    final Place place;
    final PTransition transition;
    private List<Action> actions = null;
    RepeatAction repeatAction = null;

    Output(Place place, PTransition transition) {
        this.place = place;
        this.transition = transition;
    }

    Output(Place place, PTransition transition, List<Action> actions) {
        this(place, transition);
        this.actions = actions;
    }

    String toPython(Function<String, String> variablePrefix) {
        String label = "";
        String exec = "";
        if (this.actions != null && !this.actions.isEmpty()) {
            exec = String.valueOf(exec) + this.actions.stream().map(a -> String.format(".e('%s')", PythonHelper.action(a, variablePrefix, false).replace("\"", "\\\""))).collect(Collectors.joining());
        }
        if (this.repeatAction != null) {
            if (this.repeatAction == RepeatAction.INIT) {
                exec = String.valueOf(exec) + ".er('= 0')";
            } else if (this.repeatAction == RepeatAction.INCREASE) {
                exec = String.valueOf(exec) + ".er('+= 1')";
            } else if (this.repeatAction == RepeatAction.SET_1) {
                exec = String.valueOf(exec) + ".er('= 1')";
            }
        }
        if (this.place.type == Place.PPlaceType.PARAMETERS && exec.equals("")) {
            label = "Variable('p')";
        } else if (this.place.type == Place.PPlaceType.TRANSITION && exec.equals("")) {
            String locals = "";
            if (this.transition.event instanceof TriggeredTransition) {
                TriggeredTransition e = (TriggeredTransition)this.transition.event;
                String params = IntStream.range(0, e.getParameters().size()).mapToObj(i -> {
                    Parameter tP = (Parameter)e.getTrigger().getParameters().get(i);
                    Variable p = (Variable)e.getParameters().get(i);
                    return tP.getDirection() == DIRECTION.OUT ? null : String.format("\"%s\"", p.getName());
                }).filter(p -> p != null).collect(Collectors.joining(","));
                locals = String.format("p.v([%s])", params);
            }
            label = String.format("Expression('g.gl(%s)')", locals);
        } else if (this.place.type == Place.PPlaceType.VARIABLES) {
            label = String.format("Expression(\"gl%s.g\")", exec);
        } else if (this.place.type == Place.PPlaceType.STATE) {
            assert (this.actions == null || this.actions.isEmpty()) : "Should not happen";
            label = String.format("Expression(\"''\")", exec);
        } else if (this.place.type == Place.PPlaceType.CLAUSE) {
            if (!exec.equals("")) {
                label = String.format("Expression(\"gl%s\")", exec);
            } else if (this.transition.event != null && this.transition.event instanceof ActionWithVars) {
                ActionWithVars e = (ActionWithVars)this.transition.event;
                String params = e.getParameters().stream().map(i -> String.format("\"%s\"", i.getName())).collect(Collectors.joining(","));
                String locals = String.format("p.vdict([%s])", params);
                label = String.format("Expression('gl.add(%s)')", locals);
            } else {
                label = "Variable('gl')";
            }
        } else assert (false) : "Should not happen";
        return String.format("n.add_output('%s', '%s', %s)\n", this.place.name, this.transition.getPythonName(variablePrefix), label);
    }

    static enum RepeatAction {
        INIT,
        INCREASE,
        SET_1;

    }
}

