/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BundleImageCache;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.DynamicWizard;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.NonReferencedAction;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.NonReferencedActionPage;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.PickProjectFolderPage;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.PickProjectPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class NonReferencedResourceWizard
extends DynamicWizard {
    private final NonReferencedActionPage nonReferencedActionPage;
    protected IProject project;
    IEclipseContext wizContext;
    BundleImageCache imageCache;

    public NonReferencedResourceWizard(Shell parentShell, IProject project, String bundle, IFile file, String installLocation, IEclipseContext context) {
        this.project = project;
        this.wizContext = context.createChild();
        this.wizContext.set(IProject.class, (Object)project);
        this.wizContext.set("srcPath", (Object)file.getFullPath().toOSString());
        this.wizContext.set(Runnable.class, null);
        this.wizContext.set("resolvedFile", null);
        this.imageCache = new BundleImageCache(parentShell.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), context);
        parentShell.addDisposeListener(e -> this.imageCache.dispose());
        this.wizContext.set(BundleImageCache.class, (Object)this.imageCache);
        this.nonReferencedActionPage = new NonReferencedActionPage(project, bundle, file, installLocation, this.wizContext);
    }

    @Override
    public boolean performFinish() {
        Runnable action = (Runnable)this.wizContext.get(Runnable.class);
        if (action != null) {
            action.run();
        }
        return true;
    }

    public IFile getResult() {
        return (IFile)this.wizContext.get("resolvedFile");
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof NonReferencedActionPage) {
            this.clearDynamicPages();
            NonReferencedAction action = (NonReferencedAction)((Object)this.wizContext.get(NonReferencedAction.class));
            if (action == null) {
                return null;
            }
            switch (action) {
                case COPY: {
                    PickProjectFolderPage pickProjectFolderPage = new PickProjectFolderPage(this.wizContext);
                    this.addPage((IWizardPage)pickProjectFolderPage);
                    return pickProjectFolderPage;
                }
                case COPY_TO_OTHER: {
                    PickProjectPage pickProjectPage = new PickProjectPage(this.wizContext);
                    this.addPage((IWizardPage)pickProjectPage);
                    PickProjectFolderPage pickProjectFolderPage = new PickProjectFolderPage(this.wizContext);
                    this.addPage((IWizardPage)pickProjectFolderPage);
                    return pickProjectPage;
                }
                case USE_ANYWAY: {
                    return null;
                }
                case IMPORT: {
                    return null;
                }
                case REQUIRE: {
                    return null;
                }
                case CONVERT_AND_REQUIRE: {
                    return null;
                }
            }
            return null;
        }
        return super.getNextPage(page);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.nonReferencedActionPage);
    }
}

