/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompilationUnit;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.jet.JETProblemListener;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETCompileTemplateOperation
implements IWorkspaceRunnable {
    public static final String JET_PROBLEM = "org.eclipse.emf.codegen.jetProblem";
    protected static final String JET_EXTENSION = "jet";
    protected IProject project;
    protected Collection<?> containers;
    protected List<Object> files = new ArrayList<Object>();
    protected boolean inBuild;
    protected JETCompilationMonitor compilationMonitor;
    private final State newState = new State();

    public JETCompileTemplateOperation(IProject project, Collection<?> containers) throws CoreException {
        this.project = project;
        this.containers = containers;
        for (Object container : containers) {
            if (container instanceof IContainer) {
                this.consider((IContainer)container);
                continue;
            }
            this.consider(container.toString());
        }
    }

    public JETCompileTemplateOperation(IProject project, Collection<?> containers, Collection<?> resources) throws CoreException {
        this.project = project;
        this.containers = containers;
        block0: for (Object object : resources) {
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                IContainer container = file.getParent();
                while (container != null) {
                    if (containers.contains(container)) {
                        this.consider(file);
                        continue block0;
                    }
                    container = container.getParent();
                }
                continue;
            }
            if (!(object instanceof IContainer)) continue;
            IContainer container = (IContainer)object;
            while (container != null) {
                if (containers.contains(container)) {
                    this.consider(container);
                    continue block0;
                }
                container = container.getParent();
            }
        }
    }

    public JETCompileTemplateOperation(IFile file, JETCompilationMonitor compilationMonitor) throws CoreException {
        this(file.getProject(), JETCompileTemplateOperation.getTemplateContainers(file.getProject()), Collections.singleton(file));
        this.compilationMonitor = compilationMonitor;
    }

    private static List<Object> getTemplateContainers(IProject project) {
        JETNature nature = JETNature.getRuntime(project);
        return nature == null ? Collections.emptyList() : nature.getTemplateContainers();
    }

    State getNewState() {
        return this.newState;
    }

    public List<Object> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public boolean shouldCompile() {
        return !this.files.isEmpty();
    }

    protected void consider(String uri) {
        URI baseURI = URI.createURI((String)uri);
        URI localURI = CommonPlugin.asLocalURI((URI)baseURI);
        if (localURI.isFile() && !localURI.isRelative()) {
            File file = new File(localURI.toFileString());
            if (file.isDirectory() && !uri.endsWith("/")) {
                baseURI = URI.createURI((String)(String.valueOf(uri) + "/"));
            }
            this.consider(baseURI, localURI, new File(localURI.toFileString()));
        }
    }

    protected void consider(URI baseURI, URI localURI, File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.consider(baseURI, localURI, files[i]);
                ++i;
            }
        } else if (file.isFile() && file.getName().endsWith(JET_EXTENSION) && file.getName().indexOf(46) != -1) {
            this.files.add(URI.createFileURI((String)file.getAbsolutePath()).deresolve(localURI).resolve(baseURI));
        }
    }

    protected void consider(IFile file) {
        if (file.getFileExtension() != null && file.getFileExtension().endsWith(JET_EXTENSION)) {
            this.files.add(file);
        }
    }

    protected void consider(IContainer container) throws CoreException {
        IResource[] children;
        if (container.isAccessible() && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile) {
                    this.consider((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.consider((IContainer)resource);
                }
                ++i;
            }
        }
    }

    public void run(IProgressMonitor progressMonitor) throws CoreException {
        try {
            progressMonitor.beginTask("", 3 * this.files.size());
            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCompilingTemplates_message"));
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            HashSet<IProject> jetProjects = new HashSet<IProject>();
            block13: for (Object file : this.files) {
                boolean isNotOnContainerPath;
                IFile workspaceFile = file instanceof IFile ? (IFile)file : null;
                String fileName = workspaceFile != null ? workspaceFile.getName() : file.toString();
                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCompile_message", new Object[]{fileName}));
                JETNature nature = JETNature.getRuntime(this.project);
                if (nature == null) break;
                IContainer directory = nature.getJavaSourceContainer();
                if (this.compilationMonitor == null && !directory.exists()) {
                    IFolder sourceFolder = this.project.getFolder(directory.getProjectRelativePath());
                    sourceFolder.create(true, true, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                    IJavaProject javaProject = JavaCore.create((IProject)sourceFolder.getProject());
                    ArrayList<IClasspathEntry> classPath = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                    classPath.add(JavaCore.newSourceEntry((IPath)sourceFolder.getFullPath()));
                    javaProject.setRawClasspath(classPath.toArray(new IClasspathEntry[classPath.size()]), (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                }
                IPath filePath = workspaceFile != null ? workspaceFile.getFullPath() : new Path(file.toString());
                List<Object> templateContainers = nature.getTemplateContainers();
                List<Object> templateSourceContainers = nature.getTemplateSourceContainers();
                ArrayList<String> containerLocations = new ArrayList<String>();
                for (Object container : templateContainers) {
                    if (container instanceof IContainer) {
                        containerLocations.add(URI.createPlatformResourceURI((String)((IContainer)container).getFullPath().toString(), (boolean)true).toString());
                        continue;
                    }
                    containerLocations.add(container.toString());
                }
                LinkedHashSet<String> relativePaths = new LinkedHashSet<String>();
                for (Object container : templateSourceContainers) {
                    String relativePath;
                    Path containerPath;
                    Object object = containerPath = container instanceof IContainer ? ((IContainer)container).getFullPath() : new Path(container.toString());
                    if (containerPath.isPrefixOf(filePath) && relativePaths.add(relativePath = filePath.removeFirstSegments(containerPath.segmentCount()).setDevice(null).toString())) break;
                }
                if ((isNotOnContainerPath = relativePaths.isEmpty()) && this.compilationMonitor != null) {
                    String containerLocation;
                    String relativePath = filePath.lastSegment();
                    relativePaths.add(relativePath);
                    String string = containerLocation = workspaceFile != null ? URI.createPlatformResourceURI((String)workspaceFile.getParent().getFullPath().toString(), (boolean)true).toString() : filePath.removeLastSegments(1).toString();
                    if (!containerLocations.contains(containerLocation)) {
                        containerLocations.add(0, containerLocation);
                    }
                }
                for (String relativePath : relativePaths) {
                    byte[] bytes;
                    JETSkeleton skeleton;
                    if (this.compilationMonitor == null && workspaceFile != null) {
                        workspaceFile.deleteMarkers(JET_PROBLEM, true, 0);
                    }
                    JETCompiler compiler = null;
                    JETProblemListener problemListener = new JETProblemListener();
                    StringWriter stringWriter = new StringWriter();
                    JETException parseException = null;
                    try {
                        compiler = new JETCompiler(containerLocations.toArray(new String[containerLocations.size()]), relativePath, "UTF8", this.compilationMonitor, problemListener);
                        boolean parseExceptionHandled = false;
                        try {
                            compiler.parse();
                        }
                        catch (JETException exception) {
                            parseException = exception;
                            if (this.compilationMonitor == null) {
                                parseExceptionHandled = this.handleException(exception, workspaceFile);
                            } else {
                                this.compilationMonitor.setException(exception);
                            }
                            parseException = exception;
                        }
                        compiler.generate(stringWriter);
                        if (this.compilationMonitor == null && parseException != null && !parseExceptionHandled) {
                            throw DiagnosticException.toCoreException((DiagnosticException)parseException);
                        }
                    }
                    catch (JETException exception) {
                        if (this.compilationMonitor == null) {
                            if (!this.handleException(exception, workspaceFile)) {
                                throw DiagnosticException.toCoreException((DiagnosticException)exception);
                            }
                        } else if (parseException == null) {
                            this.compilationMonitor.setException(exception);
                        }
                        if (compiler == null || compiler.getSkeleton() == null) continue;
                    }
                    if ((skeleton = compiler.getSkeleton()) != null && skeleton.getClassName().equals("")) {
                        skeleton.setClassName(fileName.substring(0, fileName.indexOf(46)));
                    }
                    if (this.compilationMonitor != null) {
                        if (!isNotOnContainerPath) continue block13;
                        JETMark start = compiler.reader.start;
                        try {
                            problemListener.handleProblem(start, start, 2, null, "jet.error.not.on.source.path", start.format("jet.mark.file.line.column"));
                        }
                        catch (JETException exception) {
                            if (this.compilationMonitor.getException() == null) continue block13;
                            this.compilationMonitor.setException(exception);
                        }
                        continue block13;
                    }
                    if (skeleton.getPackageName() != null) {
                        directory = this.getPackageContainer(directory, skeleton.getPackageName(), (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                    } else {
                        progressMonitor.worked(1);
                    }
                    IFile outputFile = workspaceRoot.getFile(directory.getFullPath().append(String.valueOf(skeleton.getClassName()) + ".java"));
                    progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETUpdate_message", new Object[]{fileName}));
                    String encoding = outputFile.getCharset();
                    String result = stringWriter.getBuffer().toString();
                    try {
                        bytes = encoding == null ? result.getBytes() : result.getBytes(encoding);
                    }
                    catch (UnsupportedEncodingException exception) {
                        bytes = result.getBytes();
                    }
                    if (!outputFile.exists()) {
                        outputFile.create((InputStream)new ByteArrayInputStream(bytes), true, progressMonitor);
                    } else {
                        boolean changed = true;
                        try {
                            InputStream inputStream = outputFile.getContents();
                            byte[] oldBytes = new byte[inputStream.available()];
                            inputStream.read(oldBytes);
                            inputStream.close();
                            changed = !Arrays.equals(oldBytes, bytes);
                        }
                        catch (IOException inputStream) {
                            // empty catch block
                        }
                        if (changed) {
                            IStatus status;
                            if (outputFile.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{outputFile}, null)).isOK()) {
                                throw new CoreException(status);
                            }
                            outputFile.setContents((InputStream)new ByteArrayInputStream(bytes), true, true, progressMonitor);
                        }
                    }
                    this.newState.addResult(outputFile, compiler.getResult().getTemplateURIs());
                    jetProjects.add(outputFile.getProject());
                    progressMonitor.worked(1);
                    for (JETException jetException : problemListener.getProblems()) {
                        this.handleException(jetException, workspaceFile);
                    }
                }
            }
            if (!this.isInBuild()) {
                for (IProject project : jetProjects) {
                    progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETJavaCompileProject_message", new Object[]{project.getFullPath()}));
                    project.build(10, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    protected IContainer getPackageContainer(IContainer root, String packagename, IProgressMonitor monitor) throws CoreException {
        StringTokenizer stringTokenizer = new StringTokenizer(packagename, ".");
        while (stringTokenizer.hasMoreTokens()) {
            IFolder newContainer = root.getFolder((IPath)new Path(stringTokenizer.nextToken()));
            if (!newContainer.exists()) {
                newContainer.create(true, true, monitor);
            }
            root = newContainer;
        }
        return root;
    }

    public boolean isInBuild() {
        return this.inBuild;
    }

    public void setInBuild(boolean build) {
        this.inBuild = build;
    }

    private boolean handleException(JETException exception, IFile file) {
        JETMark start = exception.getStart();
        if (start != null && file != null) {
            JETMark source = start;
            while (source != null && source.getFileId() != 0) {
                source = source.getParentMark();
            }
            try {
                int index;
                IMarker marker = file.createMarker(JET_PROBLEM);
                String message = exception.getMessage();
                if (start == source && (index = message.indexOf(" in ")) != -1) {
                    message = message.substring(0, index);
                }
                marker.setAttribute("message", (Object)message);
                int severity = exception.getStatus().getSeverity();
                marker.setAttribute("severity", severity == 1 ? 0 : (severity == 2 ? 1 : 2));
                marker.setAttribute("lineNumber", start.line + 1);
                if (start == source) {
                    JETMark stop = exception.getStop();
                    marker.setAttribute("charStart", start.getCursor());
                    marker.setAttribute("charEnd", stop.getCursor());
                }
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public static class JETCompilationMonitor
    extends JETCompiler.JETInputStreamHandler
    implements JETCompiler.JETCompilerResultMonitor {
        private JETCompilationUnit result;
        private JETException exception;

        public JETCompilationUnit getResult() {
            return this.result;
        }

        public void setResult(JETCompilationUnit result) {
            this.result = result;
        }

        public JETException getException() {
            return this.exception;
        }

        public void setException(JETException exception) {
            this.exception = exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class State {
        private Map<URI, List<URI>> javaFileToTemplateURIs = new LinkedHashMap<URI, List<URI>>();

        State() {
        }

        State(File stateFile) {
            this.loadState(stateFile);
        }

        Map<URI, List<URI>> getJavaFileToTemplateURIs() {
            return new LinkedHashMap<URI, List<URI>>(this.javaFileToTemplateURIs);
        }

        void addResult(IFile javaFile, List<String> templateURIs) {
            ArrayList<URI> uris = new ArrayList<URI>(templateURIs.size());
            for (String templateURI : templateURIs) {
                uris.add(URI.createURI((String)templateURI));
            }
            this.javaFileToTemplateURIs.put(URI.createPlatformResourceURI((String)javaFile.getFullPath().toString(), (boolean)true), Collections.unmodifiableList(uris));
        }

        void saveState(File stateFile) {
            block6: {
                FileOutputStream out = null;
                StringWriter writer = new StringWriter();
                writer.write("\n");
                writer.write("<state/>\n");
                try {
                    Document document = JETNature.fromInputSource(new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<state/>\n")));
                    Element root = document.getDocumentElement();
                    for (Map.Entry<URI, List<URI>> entry : this.javaFileToTemplateURIs.entrySet()) {
                        Element javaElement = document.createElement("java");
                        javaElement.setAttribute("target", entry.getKey().toString());
                        root.appendChild(javaElement);
                        for (URI uri : entry.getValue()) {
                            Element templateElement = document.createElement("template");
                            templateElement.setAttribute("source", uri.toString());
                            javaElement.appendChild(templateElement);
                        }
                    }
                    String string = JETNature.toString(document);
                    string.getBytes("UTF-8");
                    out = new FileOutputStream(stateFile);
                    out.write(string.getBytes("UTF-8"));
                    out.close();
                }
                catch (IOException exception) {
                    if (out == null) break block6;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        private void loadState(File stateFile) {
            try {
                Document document = JETNature.fromInputSource(new InputSource(stateFile.toURI().toString()));
                Element root = document.getDocumentElement();
                NodeList javaElements = root.getElementsByTagName("java");
                int i = 0;
                int javaCount = javaElements.getLength();
                while (i < javaCount) {
                    Element javaElement = (Element)javaElements.item(i);
                    String target = javaElement.getAttribute("target");
                    NodeList templateElements = javaElement.getElementsByTagName("template");
                    ArrayList<URI> templateURIs = new ArrayList<URI>();
                    int j = 0;
                    int templateCount = templateElements.getLength();
                    while (j < templateCount) {
                        Element templateElement = (Element)templateElements.item(j);
                        String source = templateElement.getAttribute("source");
                        templateURIs.add(URI.createURI((String)source));
                        ++j;
                    }
                    this.javaFileToTemplateURIs.put(URI.createURI((String)target), templateURIs);
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

