/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolMapper;
import org.eclipse.xtext.ide.server.symbol.IDocumentSymbolService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
@Beta
public class HierarchicalDocumentSymbolService
implements IDocumentSymbolService {
    @Inject
    private DocumentSymbolMapper symbolMapper;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public static boolean isValid(DocumentSymbol symbol) {
        if (symbol != null) {
            for (Field field : DocumentSymbol.class.getDeclaredFields()) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (NonNull.class != annotation.annotationType()) continue;
                    field.setAccessible(true);
                    try {
                        Object o = field.get(symbol);
                        if (o != null) continue;
                        return false;
                    }
                    catch (Throwable e) {
                        throw Exceptions.sneakyThrow((Throwable)e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public List<Either<SymbolInformation, DocumentSymbol>> getSymbols(Document document, XtextResource resource, DocumentSymbolParams params, CancelIndicator cancelIndicator) {
        return this.getSymbols(resource, cancelIndicator);
    }

    public List<Either<SymbolInformation, DocumentSymbol>> getSymbols(XtextResource resource, CancelIndicator cancelIndicator) {
        HashMap<EObject, DocumentSymbol> allSymbols = new HashMap<EObject, DocumentSymbol>();
        ArrayList<DocumentSymbol> rootSymbols = new ArrayList<DocumentSymbol>();
        Iterator<Object> itr = this.getAllContents((Resource)resource);
        while (itr.hasNext()) {
            EObject parent;
            EObject object;
            DocumentSymbol symbol2;
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            Optional<EObject> next = this.toEObject(itr.next());
            if (!next.isPresent() || !HierarchicalDocumentSymbolService.isValid(symbol2 = this.symbolMapper.toDocumentSymbol(object = (EObject)next.get()))) continue;
            allSymbols.put(object, symbol2);
            if (parent == null) {
                rootSymbols.add(symbol2);
                continue;
            }
            DocumentSymbol parentSymbol = (DocumentSymbol)allSymbols.get(parent);
            for (parent = object.eContainer(); parentSymbol == null && parent != null; parent = parent.eContainer()) {
                parentSymbol = (DocumentSymbol)allSymbols.get(parent);
            }
            if (parentSymbol == null) {
                rootSymbols.add(symbol2);
                continue;
            }
            parentSymbol.getChildren().add(symbol2);
        }
        return rootSymbols.stream().map(symbol -> Either.forRight((Object)symbol)).collect(Collectors.toList());
    }

    protected Iterator<Object> getAllContents(Resource resource) {
        return EcoreUtil.getAllProperContents((Resource)resource, (boolean)true);
    }

    protected Optional<EObject> toEObject(Object object) {
        if (object instanceof EObject) {
            return Optional.of((Object)((EObject)object));
        }
        return Optional.absent();
    }
}

