/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import java.util.Arrays;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.types.Dimension;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.TypesModel;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class HelperClassesGenerator {
    public static void generateClassesFromResource(CommaFileSystemAccess fsa, Resource r) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)r.getContents());
        TypesModel root = (TypesModel)_head;
        Functions.Function1 _function = t -> t instanceof EnumTypeDecl;
        Iterable enumTypes = IterableExtensions.filter((Iterable)root.getTypes(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = t -> t instanceof RecordTypeDecl;
        Iterable recordTypes = IterableExtensions.filter((Iterable)root.getTypes(), (Functions.Function1)_function_1);
        for (TypeDecl enumType : enumTypes) {
            String _name = enumType.getName();
            String _plus = String.valueOf(_name) + ".java";
            fsa.generateFile(_plus, HelperClassesGenerator.contentClassForEnum((EnumTypeDecl)enumType));
        }
        for (TypeDecl recordType : recordTypes) {
            String _name_1 = recordType.getName();
            String _plus_1 = String.valueOf(_name_1) + ".java";
            fsa.generateFile(_plus_1, HelperClassesGenerator.contentClassForRecord((RecordTypeDecl)recordType));
        }
    }

    public static CharSequence contentClassForEnum(EnumTypeDecl enumType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package org.eclipse.comma.restadapter;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public enum ");
        String _name = enumType.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        EList _literals = enumType.getLiterals();
        boolean _hasElements = false;
        for (EnumElement l : _literals) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "    ");
            }
            String _name_1 = l.getName();
            _builder.append(_name_1, "    ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence contentClassForRecord(RecordTypeDecl recordType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package org.eclipse.comma.restadapter;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _name = recordType.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList _fields = recordType.getFields();
        for (RecordField f : _fields) {
            _builder.append("    ");
            _builder.append("public ");
            CharSequence _fieldType = HelperClassesGenerator.fieldType((EObject)f.getType());
            _builder.append((Object)_fieldType, "    ");
            _builder.append(" ");
            String _name_1 = f.getName();
            _builder.append(_name_1, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected static CharSequence _fieldType(TypeReference typeRef) {
        return HelperClassesGenerator.fieldType((EObject)typeRef.getType());
    }

    protected static CharSequence _fieldType(TypeDecl decl) {
        if (decl instanceof RecordTypeDecl || decl instanceof EnumTypeDecl) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = decl.getName();
            _builder.append(_name);
            return _builder;
        }
        if (decl instanceof VectorTypeDecl) {
            return HelperClassesGenerator.fieldType((EObject)((VectorTypeDecl)decl).getConstructor());
        }
        if (decl instanceof SimpleTypeDecl) {
            boolean _equals;
            boolean _tripleNotEquals;
            SimpleTypeDecl type = (SimpleTypeDecl)decl;
            SimpleTypeDecl _base = ((SimpleTypeDecl)decl).getBase();
            boolean bl = _tripleNotEquals = _base != null;
            if (_tripleNotEquals) {
                type = ((SimpleTypeDecl)decl).getBase();
            }
            if (_equals = type.getName().equals("int")) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("int");
                return _builder_1;
            }
            boolean _equals_1 = type.getName().equals("real");
            if (_equals_1) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("double");
                return _builder_2;
            }
            boolean _equals_2 = type.getName().equals("string");
            if (_equals_2) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("String");
                return _builder_3;
            }
            boolean _equals_3 = type.getName().equals("bool");
            if (_equals_3) {
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("boolean");
                return _builder_4;
            }
            boolean _equals_4 = type.getName().equals("bulkdata");
            if (_equals_4) {
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append("int");
                return _builder_5;
            }
        }
        return null;
    }

    protected static CharSequence _fieldType(VectorTypeConstructor constructor) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _fieldType = HelperClassesGenerator.fieldType((EObject)constructor.getType());
        _builder.append((Object)_fieldType);
        EList _dimensions = constructor.getDimensions();
        for (Dimension d : _dimensions) {
            _builder.append("[]");
        }
        return _builder;
    }

    public static CharSequence fieldType(EObject decl) {
        if (decl instanceof TypeDecl) {
            return HelperClassesGenerator._fieldType((TypeDecl)decl);
        }
        if (decl instanceof TypeReference) {
            return HelperClassesGenerator._fieldType((TypeReference)decl);
        }
        if (decl instanceof VectorTypeConstructor) {
            return HelperClassesGenerator._fieldType((VectorTypeConstructor)decl);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(decl).toString());
    }
}

