/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.traces.events.utilities;

import com.google.gson.JsonElement;
import com.google.gson.JsonStreamParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;
import org.eclipse.comma.traces.events.traceEvents.TraceEvents;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class EventsUtilities {
    private static String components;

    public static TraceEvents readHeader(URI traceUri) {
        try {
            TraceEvents _xblockexpression = null;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            InputStream inputStream = resourceSet.getURIConverter().createInputStream(traceUri);
            InputStreamReader _inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(_inputStreamReader);
            String line = null;
            boolean eventsReached = false;
            String result = "";
            while ((line = reader.readLine()) != null && !eventsReached) {
                if ((line = line.trim()).startsWith("events") || line.startsWith("errors")) {
                    eventsReached = true;
                    continue;
                }
                String _result = result;
                String _lineSeparator = System.lineSeparator();
                String _plus = String.valueOf(line) + _lineSeparator;
                result = String.valueOf(_result) + _plus;
            }
            _xblockexpression = EventsUtilities.getTraceEventsFrom(result);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static TraceEvents readHeaderFromJson(URI traceUri) {
        try {
            JsonElement componentInstances;
            boolean _has;
            TraceEvents _xblockexpression = null;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            InputStream inputStream = resourceSet.getURIConverter().createInputStream(traceUri);
            InputStreamReader _inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            JsonStreamParser parser = new JsonStreamParser((Reader)_inputStreamReader);
            components = "components\n";
            boolean _hasNext = parser.hasNext();
            if (_hasNext && (_has = (componentInstances = parser.next()).getAsJsonObject().has("components"))) {
                Consumer<JsonElement> _function = instance -> {
                    String _components = components;
                    String _asString = instance.getAsJsonObject().get("type").getAsString();
                    String _plus = String.valueOf(_asString) + " ";
                    String _asString_1 = instance.getAsJsonObject().get("value").getAsString();
                    String _plus_1 = String.valueOf(_plus) + _asString_1;
                    String _lineSeparator = System.lineSeparator();
                    String _plus_2 = String.valueOf(_plus_1) + _lineSeparator;
                    components = String.valueOf(_components) + _plus_2;
                };
                componentInstances.getAsJsonObject().get("components").getAsJsonArray().forEach(_function);
            }
            _xblockexpression = EventsUtilities.getTraceEventsFrom(components);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static TraceEvents getTraceEventsFrom(String inputType) {
        Resource dummyres;
        block4: {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI uri = URI.createURI((String)"dummy.events");
                dummyres = resourceSet.getResource(uri, false);
                if (dummyres == null) {
                    dummyres = resourceSet.createResource(uri);
                }
                byte[] _bytes = inputType.getBytes();
                ByteArrayInputStream input = new ByteArrayInputStream(_bytes);
                dummyres.load((InputStream)input, resourceSet.getLoadOptions());
                if (dummyres != null && !dummyres.getContents().isEmpty()) break block4;
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        EObject _get = (EObject)dummyres.getContents().get(0);
        return (TraceEvents)_get;
    }
}

