/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.datatools.connectivity.oda.util.logging.LogFormatter;
import org.eclipse.datatools.connectivity.oda.util.logging.LogRecord;
import org.eclipse.datatools.connectivity.oda.util.logging.LoggingErrorHandler;
import org.eclipse.datatools.connectivity.oda.util.logging.StreamHandler;

public class FileHandler
extends StreamHandler {
    private String m_filename;
    private File m_file;

    FileHandler() {
    }

    public FileHandler(String filename) {
        this.m_filename = filename;
    }

    public FileHandler(String filename, LogFormatter formatter) {
        this.m_filename = filename;
        this.setFormatter(formatter);
    }

    public void publish(LogRecord record) {
        if (this.m_file == null) {
            this.setOutputFile(this.m_filename);
        }
        super.publish(record);
    }

    public void close() {
        super.close();
        this.m_file = null;
        this.m_filename = null;
    }

    private File getUniqueFile(String preferredFileName) {
        try {
            File file = new File(preferredFileName);
            this.createParentDirectory(file);
            int looping = 0;
            int index = preferredFileName.lastIndexOf(".");
            String prefix = preferredFileName.substring(0, index);
            String suffix = preferredFileName.substring(index, preferredFileName.length());
            while (!file.createNewFile() && looping < 10) {
                file = new File(String.valueOf(prefix) + "-" + looping + suffix);
                ++looping;
            }
            return file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    String getPreferredFilename() {
        return this.m_filename;
    }

    private void createParentDirectory(File file) {
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
    }

    void setOutputFile(String filename) {
        try {
            this.m_file = this.getUniqueFile(filename);
            if (this.m_file != null) {
                this.setOutputStream(new FileOutputStream(this.m_file));
            } else {
                this.reportError("", null, LoggingErrorHandler.OPEN_FAILURE);
            }
        }
        catch (FileNotFoundException ex) {
            this.reportError("", ex, LoggingErrorHandler.OPEN_FAILURE);
        }
    }
}

