/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCDistinctUDT;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCStructuredUDT;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EClass;

public class JDBCUserDefinedTypeLoader
extends JDBCBaseLoader {
    public static final String COLUMN_TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_CLASS_NAME = "CLASS_NAME";
    public static final String COLUMN_DATA_TYPE = "DATA_TYPE";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_BASE_TYPE = "BASE_TYPE";
    private IUDTFactory mDistinctTypeFactory;
    private IUDTFactory mJavaTypeFactory;
    private IUDTFactory mStructTypeFactory;

    public JDBCUserDefinedTypeLoader(ICatalogObject catalogObject) {
        this(catalogObject, new SchemaObjectFilterProvider("DatatoolsUDTFilterPredicate"));
    }

    public JDBCUserDefinedTypeLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        this(catalogObject, connectionFilterProvider, new DistinctTypeFactory(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(catalogObject.getCatalogDatabase())), new StructTypeFactory(), null);
    }

    public JDBCUserDefinedTypeLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider, IUDTFactory distinctTypeFactory, IUDTFactory structTypeFactory, IUDTFactory javaTypeFactory) {
        super(catalogObject, connectionFilterProvider);
        assert (catalogObject instanceof Schema);
        this.mDistinctTypeFactory = distinctTypeFactory;
        this.mJavaTypeFactory = javaTypeFactory;
        this.mStructTypeFactory = structTypeFactory;
    }

    public List loadUDTs() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadUDTs(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadUDTs(List containmentList, Collection existingUDTs) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            while (rs.next()) {
                String udtName = rs.getString(COLUMN_TYPE_NAME);
                if (udtName == null || this.isFiltered(udtName)) continue;
                UserDefinedType udt = (UserDefinedType)this.getAndRemoveSQLObject(existingUDTs, udtName);
                if (udt == null) {
                    udt = this.processRow(rs);
                    if (udt == null) continue;
                    containmentList.add(udt);
                    continue;
                }
                IUDTFactory udtFactory = null;
                switch (rs.getInt(COLUMN_DATA_TYPE)) {
                    case 2000: {
                        udtFactory = this.mJavaTypeFactory;
                        break;
                    }
                    case 2002: {
                        udtFactory = this.mStructTypeFactory;
                        break;
                    }
                    case 2001: {
                        udtFactory = this.mDistinctTypeFactory;
                    }
                }
                if (udtFactory != null) {
                    udtFactory.initialize(udt, rs);
                }
                containmentList.add(udt);
                if (!(udt instanceof ICatalogObject)) continue;
                ((ICatalogObject)udt).refresh();
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearUDTs(List existingUDTs) {
        existingUDTs.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Schema schema = this.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getUDTs(schema.getCatalog().getName(), schema.getName(), this.getJDBCFilterPattern(), null);
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getUDTs()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected UserDefinedType processRow(ResultSet rs) throws SQLException {
        IUDTFactory udtFactory = null;
        switch (rs.getInt(COLUMN_DATA_TYPE)) {
            case 2000: {
                udtFactory = this.mJavaTypeFactory;
                break;
            }
            case 2002: {
                udtFactory = this.mStructTypeFactory;
                break;
            }
            case 2001: {
                udtFactory = this.mDistinctTypeFactory;
            }
        }
        if (udtFactory == null) {
            return null;
        }
        return udtFactory.createUDT(rs);
    }

    protected Schema getSchema() {
        return (Schema)this.getCatalogObject();
    }

    public static class DistinctTypeFactory
    extends StructTypeFactory {
        private DatabaseDefinition mDatabaseDefinition;

        public DistinctTypeFactory(DatabaseDefinition databaseDefinition) {
            this.mDatabaseDefinition = databaseDefinition;
        }

        public EClass getUDTEClass() {
            return SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType();
        }

        protected UserDefinedType newUDT() {
            return new JDBCDistinctUDT();
        }

        protected DatabaseDefinition getDatabaseDefinition() {
            return this.mDatabaseDefinition;
        }

        public void initialize(UserDefinedType udt, ResultSet rs) throws SQLException {
            super.initialize(udt, rs);
            List preDefinedTypes = this.getDatabaseDefinition().getPredefinedDataTypesByJDBCEnumType(rs.getShort(JDBCUserDefinedTypeLoader.COLUMN_BASE_TYPE));
            if (preDefinedTypes.size() > 0) {
                ((DistinctUserDefinedType)udt).setPredefinedRepresentation((PredefinedDataType)preDefinedTypes.get(0));
            }
        }
    }

    public static interface IUDTFactory {
        public EClass getUDTEClass();

        public UserDefinedType createUDT(ResultSet var1) throws SQLException;

        public void initialize(UserDefinedType var1, ResultSet var2) throws SQLException;
    }

    public static class StructTypeFactory
    implements IUDTFactory {
        public EClass getUDTEClass() {
            return SQLDataTypesPackage.eINSTANCE.getStructuredUserDefinedType();
        }

        public UserDefinedType createUDT(ResultSet rs) throws SQLException {
            UserDefinedType retVal = this.newUDT();
            this.initialize(retVal, rs);
            return retVal;
        }

        protected UserDefinedType newUDT() {
            return new JDBCStructuredUDT();
        }

        public void initialize(UserDefinedType udt, ResultSet rs) throws SQLException {
            udt.setName(rs.getString(JDBCUserDefinedTypeLoader.COLUMN_TYPE_NAME));
            udt.setDescription(rs.getString(JDBCUserDefinedTypeLoader.COLUMN_REMARKS));
        }
    }
}

