/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sqleditor.IPageUpdate;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.BaseExecuteAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection.ISQLSelection;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection.SQLSelectionFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ExecuteCurrentSQLAction
extends BaseExecuteAction
implements ISelectionChangedListener,
IPageUpdate {
    private SQLEditor _sqlEditor;
    private boolean _isSourcePage = true;

    public ExecuteCurrentSQLAction(SQLEditor targetEditor) {
        this.setText(Messages.ExecuteCurrentSQLAction_label);
        this.setToolTipText(Messages.ExecuteCurrentSQLAction_tooltip);
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.ExecuteCurrentAction");
        this.setId("org.eclipse.datatools.sqltools.sqleditor.ExecuteCurrentAction");
        this.setActiveEditor(targetEditor);
        targetEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"execute_current_sql_action", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    public void run() {
        super.run();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this._sqlEditor);
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        if (this._sqlEditor != null) {
            String profileName = this._sqlEditor.getConnectionInfo().getConnectionProfileName();
            String dbName = this._sqlEditor.getConnectionInfo().getDatabaseName();
            return new DatabaseIdentifier(profileName, dbName);
        }
        return null;
    }

    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ExecuteCurrentSQLAction.this._sqlEditor);
            }
        };
        return postRun;
    }

    public String getSQLStatements() {
        if (this._sqlEditor == null) {
            return null;
        }
        IDocument doc = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        if (doc == null) {
            return null;
        }
        return this.getCurrentStatements(doc);
    }

    private String getCurrentStatements(IDocument doc) {
        String selectedText = null;
        ISQLSelection selectionPolicy = SQLSelectionFactory.getInstance().getSQLSelection(this._sqlEditor);
        selectedText = selectionPolicy.getStatements();
        return SQLToolsFacade.getDBHelper((DatabaseIdentifier)this.getDatabaseIdentifier()).preprocessSQLScript(selectedText);
    }

    public void update() {
        this.setEnabled(this._isSourcePage && this._sqlEditor != null && this._sqlEditor.isConnected() && this._sqlEditor.getSelectedText() == null);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof ITextSelection) {
            this.update();
        }
    }

    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }

    public SQLEditor getEditor() {
        return this._sqlEditor;
    }
}

