/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.PrintResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.utils.UIUtil;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import org.eclipse.datatools.sqltools.result.internal.ui.view.MultipleTabsModeSection;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.TextResultViewer;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusTextProvider;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MultipleTabsTextSection
extends MultipleTabsModeSection {
    private Text _statusView;
    private Text _messageView;
    private TextResultViewer _textViewer;
    private TextResultViewer _paramsViewer;
    private Map _viewerMap = new HashMap();

    public MultipleTabsTextSection(Composite composite, ResultsViewControl resultsViewControl) {
        super(composite, resultsViewControl);
        this.addTabSelectionListener();
    }

    public MultipleTabsTextSection(Composite composite, IResultInstance instance, ResultsViewControl resultsViewControl) {
        super(composite, instance, resultsViewControl);
        this.addTabSelectionListener();
    }

    private void addTabSelectionListener() {
        this._tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleTabsTextSection.this._textViewer = (TextResultViewer)MultipleTabsTextSection.this._viewerMap.get(e.item);
            }
        });
    }

    protected Control createStatusItem(CTabFolder ctf) {
        this._statusView = new Text((Composite)ctf, 770);
        this._statusView.setEditable(false);
        return this._statusView;
    }

    protected Control createMessageItem(CTabFolder ctf) {
        this._messageView = new Text((Composite)ctf, 770);
        this._messageView.setEditable(false);
        return this._messageView;
    }

    protected void showStatusDetail(IResultInstance instance) {
        if (instance == null) {
            this._statusView.setText("");
        } else {
            String text = StatusTextProvider.getStatusText((IResultInstance)instance);
            this._statusView.setText(text);
            this._statusView.setEditable(false);
        }
    }

    protected void showMessageDetail(IResultInstance instance) {
        if (this._splitMessages) {
            return;
        }
        if (instance == null) {
            this._messageView.setText("");
        } else {
            int count = instance.getItemCount();
            StringBuffer sb = new StringBuffer("");
            int i = 0;
            while (i < count) {
                ResultItem item = instance.getItem(i);
                if (item.getResultType() == 2) {
                    sb.append(item.getResultObject());
                }
                ++i;
            }
            this._messageView.setText(sb.toString());
        }
    }

    protected void showParameterDetail(IResultInstance instance) {
        if (instance.getParameters() != null) {
            Iterator iter = instance.getParameters().iterator();
            ArrayList newList = new ArrayList();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj == null || !(obj instanceof Parameter)) continue;
                newList.add(obj);
            }
            this.appendAndShowParameters(newList);
        }
    }

    protected void createViewerForItem(Composite composite, ResultItem item) {
        if (this._textViewer != null) {
            this._textViewer.resetUndoMgr();
        }
        ArrayList<MenuManager> items = new ArrayList<MenuManager>();
        if (item.getResultType() == 3) {
            MenuManager saveMgr = new MenuManager(Messages.Save_name);
            saveMgr.add((IAction)new SaveResultSetAction(this._statusView.getShell(), (IResultSetObject)item.getResultObject()));
            saveMgr.add((IAction)new SaveAllResultSetsAction(this._statusView.getShell(), this._resultInstance));
            items.add(saveMgr);
            MenuManager exportMgr = new MenuManager(Messages.Export_name);
            exportMgr.add((IAction)new ExportResultSetAction(this._statusView.getShell(), (IResultSetObject)item.getResultObject()));
            exportMgr.add((IAction)new ExportAllResultSetsAction(this._statusView.getShell(), this._resultInstance));
            items.add(exportMgr);
            MenuManager printMgr = new MenuManager(Messages.Print_name);
            printMgr.add((IAction)new PrintResultSetAction((IResultSetObject)item.getResultObject(), (Composite)this._tabFolder));
            printMgr.add((IAction)new PrintResultSetAction(this._resultInstance, (Composite)this._tabFolder));
            items.add(printMgr);
        }
        this._textViewer = new TextResultViewer(composite, 770, items);
        GridData gd = new GridData(1808);
        this._textViewer.getViewer().getTextWidget().setLayoutData((Object)gd);
        if (item.getResultType() == 3) {
            IResultSetObject result = (IResultSetObject)item.getResultObject();
            Label label = new Label(composite, 0);
            GridData labelGridData = new GridData();
            labelGridData.grabExcessHorizontalSpace = true;
            labelGridData.grabExcessVerticalSpace = false;
            labelGridData.heightHint = UIUtil.convertHeightInCharsToPixels(1, (Control)this._parent);
            label.setLayoutData((Object)labelGridData);
            int totalRowCount = result.getTotalRowCount();
            int rowCount = result.getRowCount();
            if (totalRowCount == rowCount) {
                label.setText(NLS.bind((String)Messages.ResultSection_resultset_tooltip1, (Object[])new Object[]{String.valueOf(rowCount)}));
            } else {
                label.setText(NLS.bind((String)Messages.ResultSection_resultset_tooltip, (Object[])new Object[]{String.valueOf(totalRowCount), String.valueOf(rowCount)}));
            }
        }
        Document document = new Document();
        document.set(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, false));
        this._textViewer.getViewer().setDocument((IDocument)document);
        this._viewerMap.put(this._tabFolder.getSelection(), this._textViewer);
    }

    protected void appendStatusView(String text) {
        this._statusView.append(text);
    }

    protected void appendMessageView(String text) {
        this._messageView.append(text);
    }

    public void onInstanceReseted() {
        super.onInstanceReseted();
        this._statusView.setText("");
        this._viewerMap.clear();
    }

    protected void appendAndShowParameters(List params) {
        if (this._paramsItem == null) {
            this._paramsItem = new CTabItem(this._tabFolder, 0, this._numberStaticTab);
            this._paramsItem.setText(Messages.MultipleTabsTextSection_parameter);
            ++this._numberStaticTab;
            this._isParamShown = true;
            this._paramTabNumber = this._numberStaticTab - 1;
            this._paramsViewer = new TextResultViewer((Composite)this._tabFolder, 770, null);
            GridData gd = new GridData(1808);
            this._paramsViewer.getViewer().getTextWidget().setLayoutData((Object)gd);
            this._paramsItem.setControl(this._paramsViewer.getViewer().getControl());
            this._viewerMap.put(this._paramsItem, this._paramsViewer);
        }
        this._paramsViewer.getViewer().setDocument((IDocument)new Document(ColumnAlignedResultItem.getParametersDsipalyStr(params, this._nullValue)));
    }

    public TextResultViewer getTextViewer() {
        return this._textViewer;
    }
}

