/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ImportProfilesDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportProfileViewAction
extends Action
implements IHandler,
IViewActionDelegate {
    private transient ListenerList listenerList = null;
    protected boolean isCompleted = false;
    private Shell shell;

    public ImportProfileViewAction() {
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.importCPs"));
    }

    public void init(IViewPart view) {
        this.shell = view.getSite().getShell();
    }

    public void init(Shell parentShell) {
        this.shell = parentShell;
    }

    public final void addHandlerListener(IHandlerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public final void dispose() {
        this.listenerList = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ImportProfilesDialog dlg;
        int ret;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null && this.shell == null) {
            return null;
        }
        if (part instanceof IViewPart) {
            this.init((IViewPart)part);
        }
        if ((ret = (dlg = new ImportProfilesDialog(this.shell)).open()) == 0) {
            final IConnectionProfile[] profiles = dlg.getProfiles();
            if (profiles == null) {
                ExceptionHandler.showException(this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), dlg.getException().getMessage(), dlg.getException());
                return null;
            }
            if (dlg.getUseLocalRepository()) {
                BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ProfileManager manager = ProfileManager.getInstance();
                        try {
                            int i = 0;
                            while (i < profiles.length) {
                                String path = ProfileManager.getInstance().getProfilePath(profiles[i]);
                                IConnectionProfile foundProfile = ProfileManager.getInstance().getProfileByFullPath(path);
                                if (foundProfile != null) {
                                    if (dlg.isOverwritten()) {
                                        ((ConnectionProfile)profiles[i]).migrate();
                                        manager.modifyProfile(profiles[i]);
                                    }
                                } else {
                                    ((ConnectionProfile)profiles[i]).migrate();
                                    manager.addProfile(profiles[i]);
                                }
                                ++i;
                            }
                        }
                        catch (ConnectionProfileException e) {
                            ExceptionHandler.showException(ImportProfileViewAction.this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
                        }
                    }
                });
            } else {
                BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            IConnectionProfile repoProfile = dlg.getSelectedRepository();
                            IConnectionProfileRepository repo = (IConnectionProfileRepository)repoProfile.getManagedConnection(IConnectionProfileRepository.class.getName()).getConnection().getRawConnection();
                            int i = 0;
                            while (i < profiles.length) {
                                if (repo.supportsProfileType(profiles[i].getProviderId()) && ((ConnectionProfileProvider)profiles[i].getProvider()).compatibleWithRepository(repoProfile)) {
                                    String path = ProfileManager.getInstance().getProfilePath(profiles[i]);
                                    path = String.valueOf(repo.getRepositoryProfile().getName()) + InternalProfileManager.PROFILE_PATH_SEPARATOR + path;
                                    IConnectionProfile foundProfile = ProfileManager.getInstance().getProfileByFullPath(path);
                                    if (foundProfile == null) {
                                        ((ConnectionProfile)profiles[i]).migrate();
                                        repo.addProfile(profiles[i]);
                                    } else if (dlg.isOverwritten()) {
                                        ((ConnectionProfile)profiles[i]).migrate();
                                        repo.modifyProfile(profiles[i]);
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (ConnectionProfileException e) {
                            ExceptionHandler.showException(ImportProfileViewAction.this.shell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
                        }
                    }
                });
            }
        }
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, false, false));
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)handlerListener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    public void run() {
        try {
            this.execute(new ExecutionEvent());
        }
        catch (ExecutionException executionException) {}
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    protected void fireHandlerChanged(HandlerEvent handlerEvent) {
        if (handlerEvent == null) {
            throw new NullPointerException();
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IHandlerListener listener = (IHandlerListener)listeners[i];
            listener.handlerChanged(handlerEvent);
            ++i;
        }
    }
}

