/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.valueexpr;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionArguments;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.AtomicValueExpression;

public abstract class FunctionValueExpression
extends AtomicValueExpression {
    protected static final String ARG_SEPARATOR = ", ";
    private ExpressionArguments m_args;
    private boolean m_ignoresDups = false;

    protected FunctionValueExpression(ExpressionArguments args) {
        if (args != null) {
            this.setArguments(args);
        }
    }

    @Override
    public String getQualifiedId() {
        return this.getClass().getName();
    }

    public ExpressionArguments getArguments() {
        if (this.m_args == null) {
            this.m_args = new ExpressionArguments();
        }
        return this.m_args;
    }

    public void setArguments(ExpressionArguments mArgs) {
        this.m_args = mArgs;
    }

    public boolean ignoresDuplicateValues() {
        return this.m_ignoresDups;
    }

    public void setIgnoreDuplicateValues(boolean ignoresDups) {
        this.m_ignoresDups = ignoresDups;
    }

    @Override
    public Integer getOdaDataType() {
        Integer functionDataType = super.getOdaDataType();
        if ((functionDataType == null || functionDataType == UNKNOWN_ODA_DATA_TYPE) && this.getArguments().hasValues()) {
            Integer derivedDataType = functionDataType;
            int numArgs = this.getArguments().valueCount();
            int i = 0;
            while (i < numArgs) {
                Integer argDataType = this.getArguments().getValueExpression(i).getOdaDataType();
                if (argDataType != null) {
                    if (derivedDataType != null && derivedDataType != argDataType) {
                        return functionDataType;
                    }
                    derivedDataType = argDataType;
                }
                ++i;
            }
            return derivedDataType;
        }
        return functionDataType;
    }

    @Override
    public void validateSyntax(ValidationContext context) throws OdaException {
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getQualifiedId());
        buffer.append("\n    ( function ");
        buffer.append(this.getArguments());
        buffer.append(" )");
        return buffer.toString();
    }
}

