/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsConstants;
import org.eclipse.datatools.sqltools.result.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.model.ResultInstanceFactory;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.SerializationHelper;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;

public class ResultInstance
implements IResultInstance {
    private static final long serialVersionUID = 1L;
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    private OperationCommand _operationCommand;
    private IResultManager _resultManager;
    private volatile transient List _results;
    private int _status = 1;
    private transient Runnable _terminateHandler;
    private volatile transient List _parameters;
    private String _date;
    private Date _ddate;
    private int _execFrequency;
    private transient List _throwables;
    private List _subResults;
    private IResultInstance _parentResult;
    private boolean _mayHaveSubResults = false;
    private String _fileName;
    private long _elapsedTime;

    public ResultInstance(IResultManager resultmanager, OperationCommand command, Runnable terminateHandler) {
        this._resultManager = resultmanager;
        this._operationCommand = command;
        this._terminateHandler = terminateHandler;
        this._ddate = new Date();
        this._date = ResultsConstants.FORMATTER.format(this._ddate);
        this._execFrequency = 1;
        this._subResults = new Vector(5);
        this._fileName = String.valueOf(String.valueOf(this._ddate.getTime())) + this.hashCode();
    }

    public ResultInstance(IResultManager resultmanager, OperationCommand command, Runnable terminateHandler, IResultInstance parentResult) {
        this(resultmanager, command, terminateHandler);
        this._parentResult = parentResult;
        if (parentResult != null) {
            parentResult.getSubResults().add(this);
        }
    }

    public void morePlainMessage(String msg) {
        if (msg == null) {
            msg = "";
        }
        this.moreResultItem(new ResultItem(msg, true));
    }

    public void moreStatusMessage(String msg) {
        if (msg == null) {
            msg = "";
        }
        this.moreResultItem(new ResultItem(msg, false));
    }

    public void moreUpdateCount(int updateCount) {
        if (updateCount < 0) {
            updateCount = 0;
        }
        this.moreResultItem(new ResultItem(updateCount));
    }

    public void moreResultSet(ResultSet resultset) throws SQLException {
        IResultSetObject r = null;
        try {
            r = ResultInstanceFactory.INSTANCE.createResultSetObject(resultset);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            _log.error("ResultInstance_error_moreResultSet", (Throwable)e);
            return;
        }
        this.moreResultItem(new ResultItem(r));
    }

    public void moreResultItem(ResultItem item) {
        this.checkList();
        this._results.add(item);
        if (this._resultManager != null) {
            this._resultManager.fireAppended(this, item, this._results.size() - 1);
        }
    }

    public OperationCommand getOperationCommand() {
        return this._operationCommand;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isFinished() {
        return this._status == 6 || this._status == 3 || this._status == 7 || this._status == 4 || this._status == 5;
    }

    public ResultItem getItem(int index) {
        this.checkList();
        return (ResultItem)this._results.get(index);
    }

    public int getItemCount() {
        this.checkList();
        return this._results.size();
    }

    public void terminate() {
        if (this._terminateHandler != null) {
            Thread th = new Thread(){

                public void run() {
                    ResultInstance.this._terminateHandler.run();
                }
            };
            th.start();
        }
        this._status = 5;
        for (IResultInstance subIns : this._subResults) {
            if (subIns.isFinished()) continue;
            subIns.terminate();
        }
        if (this._resultManager != null) {
            this._resultManager.fireStatusUpdated(this);
        }
    }

    public void dispose() {
        this.checkList();
        int i = 0;
        while (i < this._results.size()) {
            Object o;
            ResultItem ri = this.getItem(i);
            if (ri != null && (o = ri.getResultObject()) != null && o instanceof IResultSetObject) {
                ((IResultSetObject)o).dispose();
            }
            ++i;
        }
    }

    public String getExecuteTime() {
        return this._date;
    }

    public Date getExecuteDate() {
        return this._ddate;
    }

    public void updateStatus(int status) {
        this._status = status;
        if (this._resultManager != null) {
            this._resultManager.fireStatusUpdated(this);
        }
    }

    public void resetInstance() {
        this._results = null;
        this._parameters = null;
        this._status = 1;
        if (this._resultManager != null) {
            this._resultManager.fireInstanceReset(this);
        }
    }

    public void moreResultSet(IResultSetObject resultset) {
        this.moreResultItem(new ResultItem(resultset));
    }

    public void showParameters(List params) {
        this.checkList();
        this._parameters = params;
        if (this._resultManager != null) {
            this._resultManager.fireParametersShow(this, this._parameters);
        }
    }

    public boolean hasTerminateHandler() {
        return this._terminateHandler != null;
    }

    public List getParameters() {
        this.checkList();
        return this._parameters;
    }

    public int getFrequency() {
        return this._execFrequency;
    }

    public void increaseFrequency() {
        ++this._execFrequency;
        if (this._resultManager != null) {
            this._resultManager.fireStatusUpdated(this);
        }
    }

    public Throwable[] getFailThrowables() {
        if (this._throwables == null) {
            this._throwables = new ArrayList();
        }
        return this._throwables.toArray(new Throwable[this._throwables.size()]);
    }

    public void moreThrowable(Throwable th) {
        if (this._throwables == null) {
            this._throwables = new ArrayList();
        }
        this._throwables.add(th);
    }

    public void createSubResult(OperationCommand cmd, Runnable terminateHandler) {
        ResultInstanceFactory.INSTANCE.createNewInstance(cmd, terminateHandler, this);
    }

    public List getSubResults() {
        return this._subResults;
    }

    public IResultInstance getParentResult() {
        return this._parentResult;
    }

    public boolean isParentResult() {
        return this._parentResult == null;
    }

    public int calculateStatus() {
        if (this.getSubResults().size() == 0) {
            return this.getStatus();
        }
        Iterator iter = this.getSubResults().iterator();
        int severeFirstStatus = 3;
        while (iter.hasNext()) {
            IResultInstance ins = (IResultInstance)iter.next();
            int status = ins.calculateStatus();
            if (status == 1 || status == 2) {
                return status;
            }
            if (status == 5) {
                return status;
            }
            if (status <= severeFirstStatus) continue;
            severeFirstStatus = status;
        }
        return severeFirstStatus;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public boolean isMayHaveSubResults() {
        return this._mayHaveSubResults;
    }

    public void setMayHaveSubResults(boolean mayHaveSubResults) {
        this._mayHaveSubResults = mayHaveSubResults;
    }

    private void checkList() {
        if (this._results == null || this._parameters == null) {
            Object[] objs = SerializationHelper.LoadObjects(this._fileName);
            if (objs != null && objs.length == 2 && objs[0] instanceof List && objs[1] instanceof List) {
                this._parameters = (List)objs[0];
                this._results = (List)objs[1];
            }
        } else {
            return;
        }
        if (this._results == null) {
            this._results = new ArrayList(5);
        }
        if (this._parameters == null) {
            this._parameters = new ArrayList(5);
        }
    }

    public String getFileName() {
        return this._fileName;
    }

    public long getElapsedTime() {
        return this._elapsedTime;
    }

    public void setElapsedTime(long time) {
        this._elapsedTime = time;
    }

    public List getResults() {
        this.checkList();
        return this._results;
    }

    public void reclaimedTransientThings() {
        this._results = null;
        this._parameters = null;
    }
}

