/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.dialogs;

import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class OmitCurrentSchemaDialog
extends Dialog {
    IOmitSchemaInfo _omitSchemaInfo;
    String _userName;
    Button _btnUseAUIDAsCurrentSchema;
    Button _btnSpecifyCurrentSchema;
    Text _txtCurrentSchema;
    Button _btnOmitCurrentSchemaInSQL;

    public OmitCurrentSchemaDialog(Shell parentShell, IOmitSchemaInfo omitSchemaInfo, String userName) {
        super(parentShell);
        this._omitSchemaInfo = omitSchemaInfo;
        this._userName = userName;
        this.setShellStyle(133232);
        this.setBlockOnOpen(true);
    }

    public int open() {
        return super.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages._UI_DIALOG_OMIT_SCHEMA_TITLE);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId != 0 && buttonId == 1) {
            this.setReturnCode(1);
        }
        this.close();
    }

    public Control createDialogArea(Composite parent) {
        GridData gd = null;
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb1100");
        GridLayout compositeLayout = new GridLayout(1, true);
        composite.setLayout((Layout)compositeLayout);
        gd = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gd);
        this._btnOmitCurrentSchemaInSQL = new Button(composite, 32);
        this._btnOmitCurrentSchemaInSQL.setText(Messages._UI_DIALOG_OMIT_SCHEMA_IN_SQL);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 1;
        this._btnOmitCurrentSchemaInSQL.setLayoutData((Object)gd);
        this._btnOmitCurrentSchemaInSQL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OmitCurrentSchemaDialog.this.updateValues();
                OmitCurrentSchemaDialog.this.updateControls();
            }
        });
        Group groupSpecifySchema = new Group(composite, 16);
        gd = new GridData(4, 1, true, false);
        groupSpecifySchema.setLayoutData((Object)gd);
        GridLayout groupSpecifySchemaLayout = new GridLayout(3, true);
        groupSpecifySchema.setLayout((Layout)groupSpecifySchemaLayout);
        groupSpecifySchema.setText(Messages._UI_DIALOG_OMIT_SCHEMA_SPECIFY_SCHEMA_GROUP_TITLE);
        this._btnUseAUIDAsCurrentSchema = new Button((Composite)groupSpecifySchema, 16);
        String _useAUIDText = this._userName != null && this._userName.length() > 0 ? NLS.bind((String)Messages._UI_DIALOG_OMIT_SCHEMA_USE_AUID_USER_AS_CURRENT_SCHEMA, (Object)this._userName) : Messages._UI_DIALOG_OMIT_SCHEMA_USE_AUID_AS_CURRENT_SCHEMA;
        this._btnUseAUIDAsCurrentSchema.setText(_useAUIDText);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 3;
        this._btnUseAUIDAsCurrentSchema.setLayoutData((Object)gd);
        this._btnUseAUIDAsCurrentSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OmitCurrentSchemaDialog.this.updateValues();
                OmitCurrentSchemaDialog.this.updateControls();
            }
        });
        this._btnSpecifyCurrentSchema = new Button((Composite)groupSpecifySchema, 16);
        this._btnSpecifyCurrentSchema.setText(Messages._UI_DIALOG_OMIT_SCHEMA_SCHEMA_NAME);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 1;
        this._btnSpecifyCurrentSchema.setLayoutData((Object)gd);
        this._btnSpecifyCurrentSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OmitCurrentSchemaDialog.this.updateValues();
                OmitCurrentSchemaDialog.this.updateControls();
            }
        });
        this._txtCurrentSchema = new Text((Composite)groupSpecifySchema, 2048);
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 2;
        this._txtCurrentSchema.setLayoutData((Object)gd);
        this._txtCurrentSchema.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OmitCurrentSchemaDialog.this.updateValues();
                OmitCurrentSchemaDialog.this.updateControls();
            }
        });
        this.initializeValues();
        this.updateControls();
        return composite;
    }

    private void updateControls() {
        if (this._btnOmitCurrentSchemaInSQL.getSelection()) {
            this._btnUseAUIDAsCurrentSchema.setEnabled(true);
            this._btnSpecifyCurrentSchema.setEnabled(true);
            if (this._btnUseAUIDAsCurrentSchema.getSelection()) {
                this._txtCurrentSchema.setEnabled(false);
            } else {
                this._txtCurrentSchema.setEnabled(true);
            }
        } else {
            this._btnUseAUIDAsCurrentSchema.setEnabled(false);
            this._btnSpecifyCurrentSchema.setEnabled(false);
            this._txtCurrentSchema.setEnabled(false);
        }
    }

    private void updateValues() {
        this._omitSchemaInfo.setOmitCurrentSchema(this._btnOmitCurrentSchemaInSQL.getSelection());
        this._omitSchemaInfo.setUseAUIDAsCurrentSchema(this._btnUseAUIDAsCurrentSchema.getSelection());
        this._omitSchemaInfo.setCurrentSchema(this._txtCurrentSchema.getText() == null ? "" : this._txtCurrentSchema.getText());
    }

    private void initializeValues() {
        this._btnOmitCurrentSchemaInSQL.setSelection(this._omitSchemaInfo.getOmitCurrentSchema());
        if (this._omitSchemaInfo.getUseAUIDAsCurrentSchema()) {
            this._btnUseAUIDAsCurrentSchema.setSelection(true);
            this._btnSpecifyCurrentSchema.setSelection(false);
        } else {
            this._btnSpecifyCurrentSchema.setSelection(true);
            this._btnUseAUIDAsCurrentSchema.setSelection(false);
        }
        if (this._omitSchemaInfo.getCurrentSchema() != null && this._omitSchemaInfo.getCurrentSchema().length() > 0) {
            this._txtCurrentSchema.setText(this._omitSchemaInfo.getCurrentSchema());
        }
    }
}

