/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.routineeditor.ui.Messages;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorUIActivator;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveRoutineStatusHandler
implements IStatusHandler {
    public static final String PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH = "org.eclipse.debug.ui.save_dirty_editors_before_launch";
    Object[] fSaves = null;

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        IConnectionProfile profile = null;
        IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.debug.ui");
        final String save = prefs.get(PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH, "prompt");
        if (source != null) {
            if (source instanceof ProcIdentifier) {
                try {
                    profile = ProfileUtil.getProfile((String)((ProcIdentifier)source).getProfileName());
                }
                catch (NoSuchProfileException noSuchProfileException) {}
            } else if (source instanceof IConnectionProfile) {
                profile = (IConnectionProfile)source;
            }
        }
        if (profile != null) {
            final int[] result = new int[1];
            final IConnectionProfile p = profile;
            SQLEditorPlugin.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    result[0] = SaveRoutineStatusHandler.this.showSaveDialog(p, !save.equals("never"), save.equals("prompt"));
                }
            });
            if (result[0] == 0) {
                this.doSave();
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (save.equals("never")) {
            return Boolean.TRUE;
        }
        if (RoutineEditorUIActivator.getDefault().getWorkbench().getActiveWorkbenchWindow() == null) {
            return Boolean.FALSE;
        }
        boolean cancel = PlatformUI.getWorkbench().saveAllEditors("prompt".equals(save));
        return cancel;
    }

    protected IEditorPart[] getScopedDirtyEditors(IConnectionProfile targetProfile) {
        ArrayList<IEditorPart> dirtyparts = new ArrayList<IEditorPart>();
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int l = 0;
        while (l < windows.length) {
            IWorkbenchPage[] pages = windows[l].getPages();
            int i = 0;
            while (i < pages.length) {
                IEditorPart[] eparts = pages[i].getDirtyEditors();
                int j = 0;
                while (j < eparts.length) {
                    IConnectionProfile profile = (IConnectionProfile)eparts[j].getEditorInput().getAdapter(IConnectionProfile.class);
                    if (profile != null && targetProfile.equals(profile) & !dirtyparts.contains(eparts[j])) {
                        dirtyparts.add(eparts[j]);
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        return dirtyparts.toArray(new IEditorPart[dirtyparts.size()]);
    }

    protected void doSave() {
        if (this.fSaves != null) {
            int i = 0;
            while (i < this.fSaves.length) {
                final SaveProgressMonitor monitor = new SaveProgressMonitor();
                final IEditorPart part = (IEditorPart)this.fSaves[i];
                SQLEditorPlugin.getStandardDisplay().syncExec(new Runnable(){

                    public void run() {
                        part.doSave((IProgressMonitor)monitor);
                    }
                });
                while (!monitor.isDone() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++i;
            }
        }
    }

    protected int showSaveDialog(IConnectionProfile profile, boolean save, boolean prompt) {
        if (save) {
            Object[] editors = this.getScopedDirtyEditors(profile);
            if (prompt && editors.length > 0) {
                int[] result = new int[1];
                ScopedResourcesSelectionDialog lsd = new ScopedResourcesSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), new AdaptableList((IAdaptable[])editors), (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), Messages.SaveScopeResourcesHandler_2);
                lsd.setInitialSelections(editors);
                lsd.setTitle(Messages.SaveScopeResourcesHandler_3);
                result[0] = lsd.open();
                if (result[0] == 1) {
                    return 1;
                }
                this.fSaves = lsd.getResult();
            } else {
                this.fSaves = editors;
            }
        }
        return 0;
    }

    class SaveProgressMonitor
    extends NullProgressMonitor {
        private boolean isDone = false;

        SaveProgressMonitor() {
        }

        public void done() {
            super.done();
            this.isDone = true;
        }

        public boolean isDone() {
            return this.isDone;
        }
    }

    class ScopedResourcesSelectionDialog
    extends ListSelectionDialog {
        private final String SETTINGS_ID = "org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG";
        private final String SELECT_RESOURCES_TO_SAVE_DIALOG = "org.eclipse.debug.ui.select_resources_to_save_dialog";
        Button fSavePref;

        public ScopedResourcesSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
            this.SETTINGS_ID = "org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG";
            this.SELECT_RESOURCES_TO_SAVE_DIALOG = "org.eclipse.debug.ui.select_resources_to_save_dialog";
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ctrl = (Composite)super.createDialogArea(parent);
            this.fSavePref = new Button(ctrl, 32);
            this.fSavePref.setText(Messages.SaveScopeResourcesHandler_1);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ctrl, "org.eclipse.debug.ui.select_resources_to_save_dialog");
            return ctrl;
        }

        protected void okPressed() {
            String val = this.fSavePref.getSelection() ? "always" : "prompt";
            IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.debug.ui");
            prefs.put(SaveRoutineStatusHandler.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH, val);
            super.okPressed();
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings settings = RoutineEditorUIActivator.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection("org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG");
            if (section == null) {
                section = settings.addNewSection("org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG");
            }
            return section;
        }
    }
}

