/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;

public class SourceViewerAction
extends ResourceAction
implements IUpdate {
    protected ISourceViewer fSourceViewer;
    protected int fOperationCode = -1;
    protected ITextOperationTarget fOperationTarget;
    private boolean isActive = false;

    public SourceViewerAction(ResourceBundle bundle, String prefix, ISourceViewer viewer) {
        super(bundle, prefix);
        this.setViewer(viewer);
    }

    public SourceViewerAction(ResourceBundle bundle, String prefix, ISourceViewer viewer, int operationCode) {
        super(bundle, prefix);
        this.fSourceViewer = viewer;
        this.fOperationCode = operationCode;
        this.update();
    }

    public void setViewer(ISourceViewer viewer) {
        this.fSourceViewer = viewer;
    }

    public void run() {
        if (this.fOperationCode != -1 && this.fOperationTarget != null) {
            this.setAsActive(true);
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    public void update() {
        boolean wasEnabled = this.isEnabled();
        this.fOperationTarget = this.fSourceViewer != null && this.fOperationCode != -1 ? this.fSourceViewer.getTextOperationTarget() : null;
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(isEnabled);
        if (wasEnabled != isEnabled) {
            this.firePropertyChange("enabled", new Boolean(wasEnabled), new Boolean(isEnabled));
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setAsActive(boolean isActive) {
        this.isActive = isActive;
    }
}

