/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sql.parser.ParseException;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.Token;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLOutlinePage;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class SQLUpdater
implements Runnable,
IDocumentListener,
IPropertyChangeListener {
    public static final String SOURCE_ID = "SQL_SOURCE_ID";
    private SQLEditor _editor = null;
    private SQLOutlinePage _fOutlinePage = null;
    private IEditorInput _input = null;
    private IAnnotationModel _annotationModel;
    private IResource _resource;
    private String _portableTarget = "";
    private ArrayList _staleAnnotations = new ArrayList();
    private boolean _remembered = false;
    private ParsingResult _result;
    private boolean _needToParse = true;

    public SQLUpdater(SQLEditor editor) {
        this._editor = editor;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.setInput(this._editor.getEditorInput());
        this.rememberAnnotations();
    }

    public void documentChanged(DocumentEvent event) {
        this.setNeedToParse(true);
        this._editor.getSite().getShell().getDisplay().timerExec(1000, (Runnable)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("PreferenceConstants.EDITOR_PORTABILITY_CHECK_TARGET")) {
            this.rememberAnnotations();
            this.run();
        }
    }

    public void setOutlinePage(SQLOutlinePage outlinePage) {
        this._fOutlinePage = outlinePage;
        if (this._fOutlinePage != null && this._result != null) {
            this._fOutlinePage.setInput((Node)this._result.getRootNode());
        }
    }

    public void run() {
        StyledText text;
        ISourceViewer sv;
        this.setInput(this._editor.getEditorInput());
        if (!this.enableSyntaxValidation()) {
            this.removeMarkers();
            return;
        }
        try {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            ISchedulingRule rule = ruleFactory.markerRule(this._resource);
            this._resource.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SQLUpdater.this.update();
                }
            }, rule, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            SQLEditorPlugin.getDefault().log(SQLEditorResources.SQLUpdater_error_annotation, e);
        }
        if (this._editor != null && (sv = this._editor.getSV()) != null && (text = sv.getTextWidget()) != null && !text.isDisposed()) {
            text.redraw();
        }
        this.setNeedToParse(false);
    }

    private void update() {
        SQLDevToolsConfiguration pf;
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this._editor.getConnectionInfo().getDatabaseVendorDefinitionId());
        SQLParser p = f.getSQLService().getSQLParser();
        ISourceViewer viewer = this._editor.getSV();
        if (viewer == null) {
            return;
        }
        String content = viewer.getDocument().get();
        if ((content = String.valueOf(content) + "\n") == null || p == null) {
            this.removeMarkers(false);
            return;
        }
        boolean useDelimiter = this._editor.getSQLType() == 100;
        ParserParameters parserParameters = new ParserParameters(useDelimiter, this._editor.getSQLType());
        this._result = p.parse(content, parserParameters);
        IDocument document = this._editor.getDocumentProvider().getDocument((Object)this._input);
        this._result.getRootNode().setDocument(document);
        this._editor.setParsingResult(this._result);
        this.removeMarkers(false);
        SQLParser pp = null;
        this._portableTarget = SQLEditorPlugin.getDefault().getPreferenceStore().getString("PreferenceConstants.EDITOR_PORTABILITY_CHECK_TARGET");
        if (this._portableTarget != null && (pp = (pf = SQLToolsFacade.getConfigurationByDBDefName((String)this._portableTarget)).getSQLService().getSQLParser()) != null && !pp.getClass().equals(p.getClass())) {
            ParsingResult presult = pp.parse(content, parserParameters);
            this.updatePortableAnnotation(presult.getExceptions());
        }
        ArrayList exceptions = this._result.getExceptions();
        this.updateErrorAnnotation(exceptions);
        if (this._fOutlinePage != null) {
            this._fOutlinePage.setInput((Node)this._result.getRootNode());
        }
    }

    private void updateErrorAnnotation(ArrayList exceptions) {
        try {
            for (ParseException ex : exceptions) {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("severity", new Integer(2));
                String storageName = "";
                if (!(this._input instanceof IFileEditorInput)) {
                    storageName = String.valueOf(this._input.getName()) + ": ";
                }
                attrs.put("message", String.valueOf(storageName) + ex.getMessage());
                attrs.put("short_message", String.valueOf(storageName) + ex.getShortMessage());
                this.updateAnnotation(ex, "org.eclipse.datatools.sqltools.sqleditor.syntaxproblem", attrs);
            }
        }
        catch (CoreException e) {
            SQLEditorPlugin.getDefault().log(SQLEditorResources.SQLUpdater_error_annotation, e);
        }
    }

    private void updatePortableAnnotation(ArrayList exceptions) {
        try {
            for (ParseException ex : exceptions) {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("userEditable", Boolean.FALSE);
                String storageName = "";
                if (!(this._input instanceof IFileEditorInput)) {
                    storageName = String.valueOf(this._input.getName()) + ": ";
                }
                attrs.put("message", String.valueOf(storageName) + NLS.bind((String)SQLEditorResources.SQLUpdater_nonportable, (Object[])new String[]{this._portableTarget}) + ex.getMessage());
                this.updateAnnotation(ex, "org.eclipse.datatools.sqltools.sqleditor.portabilitytask", attrs);
            }
        }
        catch (CoreException e) {
            SQLEditorPlugin.getDefault().log(SQLEditorResources.SQLUpdater_error_annotation, e);
        }
    }

    private void updateAnnotation(ParseException ex, String markerType, Map attributes) throws CoreException {
        if (this._annotationModel == null) {
            return;
        }
        IMarker marker = this._resource.createMarker(markerType);
        marker.setAttributes(attributes);
        marker.setAttribute("transient", true);
        marker.setAttribute(SOURCE_ID, (Object)this.getMarkerSourceId());
        Token errorToken = ex.currentToken.next;
        int start = 0;
        int end = 0;
        int line = 0;
        try {
            IDocument document = this._editor.getSV().getDocument();
            if (ex.currentToken.beginLine < 1 && (errorToken.image == null || "".equals(errorToken.image))) {
                return;
            }
            if (errorToken.image == null || "".equals(errorToken.image)) {
                start = document.getLineOffset(ex.currentToken.beginLine - 1) + ex.currentToken.beginColumn - 1;
                end = document.getLineOffset(ex.currentToken.endLine - 1) + ex.currentToken.endColumn;
                line = ex.currentToken.beginLine;
            } else {
                start = document.getLineOffset(errorToken.beginLine - 1) + errorToken.beginColumn - 1;
                end = document.getLineOffset(errorToken.endLine - 1) + errorToken.endColumn;
                line = errorToken.beginLine;
            }
            if (start < 0 || end - start < 0) {
                return;
            }
        }
        catch (BadLocationException e1) {
            SQLEditorPlugin.getDefault().log(SQLEditorResources.SQLUpdater_error_location, e1);
        }
        marker.setAttributes(new String[]{"charStart", "charEnd", "lineNumber"}, new Object[]{new Integer(start), new Integer(end), new Integer(line)});
        MarkerAnnotation anno = new MarkerAnnotation(marker);
        Position position = new Position(start, end - start);
        this._annotationModel.addAnnotation((Annotation)anno, position);
    }

    void setInput(IEditorInput input) {
        this._input = input;
        this._resource = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : ResourcesPlugin.getWorkspace().getRoot();
        this._annotationModel = this._editor.getDocumentProvider().getAnnotationModel((Object)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberAnnotations() {
        ArrayList arrayList = this._staleAnnotations;
        synchronized (arrayList) {
            this._staleAnnotations = new ArrayList();
            if (this._annotationModel != null) {
                Iterator iter = this._annotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation anno = (Annotation)iter.next();
                    if (!(anno instanceof MarkerAnnotation)) continue;
                    IMarker marker = ((MarkerAnnotation)anno).getMarker();
                    String type = "";
                    try {
                        type = marker.getType();
                    }
                    catch (CoreException coreException) {
                        this._staleAnnotations.add(anno);
                        continue;
                    }
                    if (!type.equals("org.eclipse.datatools.sqltools.sqleditor.syntaxproblem") && !type.equals("org.eclipse.datatools.sqltools.sqleditor.portabilitytask")) continue;
                    this._staleAnnotations.add(anno);
                }
            }
            this._remembered = true;
        }
    }

    public void removeMarkers() {
        this.removeMarkers(true);
    }

    public void removeMarkers(boolean group) {
        if (!this._remembered) {
            this.rememberAnnotations();
        }
        if (group) {
            try {
                IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                ISchedulingRule rule = ruleFactory.markerRule(this._resource);
                this._resource.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        SQLUpdater.this.removeRememberedMarkers();
                    }
                }, rule, 0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        } else {
            this.removeRememberedMarkers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRememberedMarkers() {
        ArrayList arrayList = this._staleAnnotations;
        synchronized (arrayList) {
            for (Annotation anno : this._staleAnnotations) {
                if (anno instanceof MarkerAnnotation) {
                    IMarker marker = ((MarkerAnnotation)anno).getMarker();
                    try {
                        marker.delete();
                        anno.markDeleted(true);
                    }
                    catch (CoreException e2) {
                        SQLEditorPlugin.getDefault().log(SQLEditorResources.SQLUpdater_error_removemarker, e2);
                    }
                }
                this._annotationModel.removeAnnotation(anno);
            }
            this._remembered = false;
        }
        try {
            if (this._resource instanceof IFile) {
                this._resource.deleteMarkers("org.eclipse.datatools.sqltools.sqleditor.syntaxproblem", false, 0);
                this._resource.deleteMarkers("org.eclipse.datatools.sqltools.sqleditor.portabilitytask", false, 0);
            } else {
                IMarker[] markers = this._resource.findMarkers("org.eclipse.datatools.sqltools.sqleditor.syntaxproblem", false, 0);
                String markerSourceId = this.getMarkerSourceId();
                int i = 0;
                while (i < markers.length) {
                    if (markerSourceId.equals(markers[i].getAttribute(SOURCE_ID))) {
                        markers[i].delete();
                    }
                    ++i;
                }
                markers = this._resource.findMarkers("org.eclipse.datatools.sqltools.sqleditor.portabilitytask", false, 0);
                i = 0;
                while (i < markers.length) {
                    if (markerSourceId.equals(markers[i].getAttribute(SOURCE_ID))) {
                        markers[i].delete();
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            SQLEditorPlugin.getDefault().log(SQLEditorResources.SQLUpdater_error_removemarker, e);
        }
    }

    private boolean enableSyntaxValidation() {
        if (this._editor != null && this._editor.getConnectionInfo() != null) {
            ISQLEditorConnectionInfo connInfo = this._editor.getConnectionInfo();
            SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration((DatabaseIdentifier)this._editor.getDatabaseIdentifier(), (DatabaseVendorDefinitionId)connInfo.getDatabaseVendorDefinitionId());
            SQLParser p = conf.getSQLService().getSQLParser();
            if (p == null || !p.isComplete()) {
                return false;
            }
        }
        IPreferenceStore preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore();
        boolean enableSyntaxValidation = true;
        boolean isMaxLineLimitation = preferenceStore.getBoolean("syntax.validation.max.line");
        if (!preferenceStore.getBoolean("syntax.validation")) {
            enableSyntaxValidation = false;
        } else if (isMaxLineLimitation) {
            int lines = this._editor.getSV().getDocument().getNumberOfLines();
            int maximunLines = Integer.parseInt(preferenceStore.getString("syntax.validation.max.line.number"));
            if (preferenceStore.getBoolean("show.dailog.for.syntax.validation")) {
                if (lines >= maximunLines) {
                    MessageDialogWithToggle dialog;
                    Shell shell = SQLEditorPlugin.getActiveWorkbenchShell();
                    if (shell.getMinimized()) {
                        shell.setMinimized(false);
                    }
                    if ((dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)SQLEditorResources.SQLUpdate_dialog_title, (String)NLS.bind((String)SQLEditorResources.SQLUpdate_dialog_message, (Object[])new Object[]{Integer.toString(maximunLines)}), (String)SQLEditorResources.SQLUpdate_dialog_toggle, (boolean)false, (IPreferenceStore)SQLEditorPlugin.getDefault().getPreferenceStore(), (String)"show.dailog.for.syntax.validation")).getReturnCode() == 2) {
                        enableSyntaxValidation = false;
                    } else if (dialog.getReturnCode() == 3 && preferenceStore.getString("show.dailog.for.syntax.validation").equals("never")) {
                        enableSyntaxValidation = true;
                        preferenceStore.setValue("syntax.validation.max.line", false);
                    } else {
                        enableSyntaxValidation = true;
                    }
                }
            } else {
                enableSyntaxValidation = lines < maximunLines;
            }
        }
        if (!enableSyntaxValidation) {
            if (this._fOutlinePage != null) {
                this._fOutlinePage.update(null);
            }
            if (this._annotationModel != null) {
                this.removeMarkers();
            }
            return false;
        }
        return true;
    }

    public boolean needToParse() {
        return this._needToParse;
    }

    public void setNeedToParse(boolean needToParse) {
        this._needToParse = needToParse;
    }

    private String getMarkerSourceId() {
        return ((ISQLEditorInput)this._editor.getEditorInput()).getId();
    }
}

