/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLToolsConnectListener;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SchemaEditorsHandler
implements ISQLToolsConnectListener,
ISQLToolsProfileListener {
    int _saveResult;

    public void aboutToClose(ConnectEvent event) {
    }

    public void closeConnection(ConnectEvent event) {
        if (SOEUIPlugin.getDefault() == null) {
            return;
        }
        IEditorReference[] editorRefs = SOEUIPlugin.getActiveWorkbenchPage().getEditorReferences();
        ArrayList<IEditorPart> openedClearEditors = new ArrayList<IEditorPart>();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part instanceof ISchemaObjectEditor) {
                ISchemaObjectEditor editor = (ISchemaObjectEditor)part;
                ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)editor.getEditorInput();
                if (event.getConnectionProfile().getName().equals(input.getDatabaseIdentifier().getProfileName())) {
                    openedClearEditors.add(part);
                }
            }
            ++i;
        }
        for (final IEditorPart p : openedClearEditors) {
            SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    SOEUIPlugin.getActiveWorkbenchPage().closeEditor(p, false);
                }
            });
        }
    }

    public boolean okToClose(ConnectEvent event) {
        final ArrayList editors = new ArrayList();
        IEditorReference[] editorRefs = SOEUIPlugin.getActiveWorkbenchPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            final IEditorPart part = editorRefs[i].getEditor(false);
            if (part instanceof ISchemaObjectEditor) {
                ISchemaObjectEditor editor = (ISchemaObjectEditor)part;
                ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)editor.getEditorInput();
                if (event.getConnectionProfile().getName().equals(input.getDatabaseIdentifier().getProfileName())) {
                    SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (part.isDirty()) {
                                editors.add(part);
                            }
                        }
                    });
                }
            }
            ++i;
        }
        if (editors.size() > 0) {
            SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    SaveDirtyEditorsSelectionDialog dlg = new SaveDirtyEditorsSelectionDialog(SOEUIPlugin.getActiveWorkbenchShell(), new AdaptableList((Collection)editors), (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), Messages.SchemaEditorsHandler_select_to_save);
                    dlg.setInitialElementSelections(editors);
                    SchemaEditorsHandler.this._saveResult = dlg.open();
                }
            });
            return this._saveResult != 1;
        }
        return true;
    }

    public void profileConnected(ConnectEvent event) {
    }

    public void profileAdded(IConnectionProfile profile) {
    }

    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect, boolean onlyNameChanged, ConnectProfile oldProfile) {
    }

    public void profileDeleted(IConnectionProfile profile) {
    }

    class SaveDirtyEditorsSelectionDialog
    extends ListSelectionDialog {
        public SaveDirtyEditorsSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
            this.setTitle(Messages.SchemaEditorsHandler_save_disconnect);
        }

        protected void okPressed() {
            super.okPressed();
            Object[] selectedItems = this.getResult();
            if (selectedItems != null) {
                int i = 0;
                while (i < selectedItems.length) {
                    if (selectedItems[i] != null && selectedItems[i] instanceof ISchemaObjectEditor) {
                        ISchemaObjectEditor editor = (ISchemaObjectEditor)selectedItems[i];
                        editor.setSyncSaveMode();
                        editor.setNeedRefreshAfterSave(false);
                        IWorkbenchPage page = SOEUIPlugin.getActiveWorkbenchPage();
                        boolean succeeded = page.saveEditor((IEditorPart)editor, false);
                        if (!succeeded) {
                            this.setReturnCode(1);
                        } else {
                            page.closeEditor((IEditorPart)editor, false);
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

