/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.editor;

import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class SQLImageDescriptor
extends CompositeImageDescriptor {
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int PORTABLE = 4;
    private ImageDescriptor _fBaseImage;
    private int _fFlags;
    private Point _fSize;

    public SQLImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this._fBaseImage = baseImage;
        Assert.isNotNull((Object)this._fBaseImage);
        this._fFlags = flags;
        Assert.isTrue((this._fFlags >= 0 ? 1 : 0) != 0);
        this._fSize = size;
        Assert.isNotNull((Object)this._fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this._fFlags = adornments;
    }

    public int getAdronments() {
        return this._fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this._fSize = size;
    }

    public Point getImageSize() {
        return new Point(this._fSize.x, this._fSize.y);
    }

    protected Point getSize() {
        return this._fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !SQLImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        SQLImageDescriptor other = (SQLImageDescriptor)((Object)object);
        return this._fBaseImage.equals(other._fBaseImage) && this._fFlags == other._fFlags && this._fSize.equals((Object)other._fSize);
    }

    public int hashCode() {
        return this._fBaseImage.hashCode() | this._fFlags | this._fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this._fBaseImage);
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            SQLEditorPlugin.getDefault().log("Image data not available: " + descriptor.toString());
        }
        return data;
    }

    private void drawTopRight() {
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        int x = size.x;
        int flags = this._fFlags;
        if ((flags & 4) != 0) {
            ImageData data = this.getImageData(ImageDescriptor.createFromImage((Image)SQLEditorResources.getImage("over16/portable_co")));
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
    }

    private void drawBottomLeft() {
        ImageData data;
        Point size = this.getSize();
        int x = 0;
        if ((this._fFlags & 2) != 0) {
            data = this.getImageData(ImageDescriptor.createFromImage((Image)SQLEditorResources.getImage("over16/error_co")));
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
        if ((this._fFlags & 1) != 0) {
            data = this.getImageData(ImageDescriptor.createFromImage((Image)SQLEditorResources.getImage("over16/warning_co")));
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
    }
}

