/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumnCheckConstraint;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.emf.common.util.EList;

public class TableModelUtil {
    public static List getMatchedColumnUniqueConstraint(BaseTable table, Column column) {
        ArrayList<UniqueConstraint> constraints = new ArrayList<UniqueConstraint>();
        for (UniqueConstraint unique : table.getUniqueConstraints()) {
            EList members = unique.getMembers();
            if (members.size() != 1 || !members.get(0).equals(column)) continue;
            constraints.add(unique);
        }
        return constraints;
    }

    public static List getMatchedColumnCheckConstraint(BaseTable table, Column column) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (Constraint obj : table.getConstraints()) {
            SybaseASABaseColumnCheckConstraint columnCk;
            if (!(obj instanceof SybaseASABaseColumnCheckConstraint) || (columnCk = (SybaseASABaseColumnCheckConstraint)obj).getColumn() != column) continue;
            constraints.add(obj);
        }
        return constraints;
    }

    public static List getMatchedColumnForeignKeys(BaseTable table, Column column) {
        ArrayList<ForeignKey> constraints = new ArrayList<ForeignKey>();
        for (ForeignKey fk : table.getForeignKeys()) {
            EList members = fk.getMembers();
            if (members.size() < 1 || !members.contains(column)) continue;
            constraints.add(fk);
        }
        return constraints;
    }

    public static boolean isReferencedColumn(BaseTable table, Column column) {
        for (Constraint constraint : table.getConstraints()) {
            SybaseASABaseColumnCheckConstraint columnCk;
            ReferenceConstraint refConstraint;
            if (constraint instanceof ReferenceConstraint && (refConstraint = (ReferenceConstraint)constraint).getMembers().contains((Object)column)) {
                return true;
            }
            if (!(constraint instanceof SybaseASABaseColumnCheckConstraint) || (columnCk = (SybaseASABaseColumnCheckConstraint)constraint).getColumn() != column) continue;
            return true;
        }
        return false;
    }

    public static void removeColumnFromRefConstraints(BaseTable table, Column column) {
        for (Constraint constraint : table.getConstraints()) {
            ReferenceConstraint refConstraint;
            if (!(constraint instanceof ReferenceConstraint) || !(refConstraint = (ReferenceConstraint)constraint).getMembers().contains((Object)column)) continue;
            refConstraint.getMembers().remove((Object)column);
        }
    }

    public static void removePrivilegeForColumn(Column column, List authids) {
        for (AuthorizationIdentifier authid : authids) {
            Iterator pIter = authid.getReceivedPrivilege().iterator();
            ArrayList<Privilege> privilegeTobeRemoved = new ArrayList<Privilege>();
            while (pIter.hasNext()) {
                Privilege p = (Privilege)pIter.next();
                if (p.getObject() != column) continue;
                privilegeTobeRemoved.add(p);
            }
            authid.getReceivedPrivilege().removeAll(privilegeTobeRemoved);
        }
    }

    public static List getNotNullableColumns(BaseTable table) {
        if (table == null || table.getColumns() == null) {
            return new ArrayList(0);
        }
        ArrayList<Column> notNullableColumns = new ArrayList<Column>();
        for (Column col : table.getColumns()) {
            if (col.isNullable()) continue;
            notNullableColumns.add(col);
        }
        return notNullableColumns;
    }

    public static String constructConstraintNamesList(List matches) {
        StringBuffer sb = new StringBuffer("");
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            String name;
            if (!sb.toString().equals("")) {
                sb.append(",");
            }
            if ((name = ((Constraint)iter.next()).getName()) == null || name.equals("")) {
                name = " ";
            }
            sb.append(name);
        }
        return sb.toString();
    }
}

