/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.sql;

import java.util.List;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLWordFinder;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.keys.KeySequence;

public abstract class AbstractSQLEditorTextHover
implements ITextHover,
ITextHoverExtension {
    private static ICommand _fCommand;

    static {
        ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
        _fCommand = commandManager.getCommand("org.eclipse.datatools.sqltools.sqleditor.show.sql.info");
        if (!_fCommand.isDefined()) {
            _fCommand = null;
        }
    }

    public abstract void setEditor(IEditorPart var1);

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 0;
                DefaultInformationControl control = new DefaultInformationControl(parent, 16, style, null, AbstractSQLEditorTextHover.this.getTooltipAffordanceString());
                control.setSizeConstraints(60, 10);
                return control;
            }
        };
    }

    protected String getTooltipAffordanceString() {
        if (!SQLEditorPlugin.getDefault().getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return null;
        }
        KeySequence[] sequences = this.getKeySequences();
        if (sequences == null) {
            return null;
        }
        String keySequence = sequences[0].format();
        return NLS.bind((String)SQLEditorResources.SQLErrorHover_makeStickyHint, (Object[])new String[]{keySequence});
    }

    private KeySequence[] getKeySequences() {
        List list;
        if (_fCommand != null && !(list = _fCommand.getKeySequenceBindings()).isEmpty()) {
            KeySequence[] keySequences = new KeySequence[list.size()];
            int i = 0;
            while (i < keySequences.length) {
                keySequences[i] = ((IKeySequenceBinding)list.get(i)).getKeySequence();
                ++i;
            }
            return keySequences;
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return SQLWordFinder.findWord(textViewer.getDocument(), offset);
    }
}

