/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.connection;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionAdapter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ResultSetAdapter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.SQLExceptionHandler;

public class StatementAdapter
implements Statement {
    private ConnectionAdapter conection;
    private Statement statement;
    private static ArrayList handers = null;

    public StatementAdapter(ConnectionAdapter connection, Statement statement) {
        this.conection = connection;
        this.statement = statement;
    }

    public void addBatch(String arg0) throws SQLException {
        this.statement.addBatch(arg0);
    }

    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public boolean equals(Object arg0) {
        return this.statement.equals(arg0);
    }

    public boolean execute(String arg0) throws SQLException {
        return this.statement.execute(arg0);
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return this.statement.execute(arg0, arg1);
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    public ResultSet executeQuery(String arg0) throws SQLException {
        try {
            ResultSet resultSet = this.statement.executeQuery(arg0);
            return new ResultSetAdapter(this, resultSet);
        }
        catch (SQLException e) {
            this.notifySQLExceptionHandler(e);
            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, e.getClass().getName(), (Throwable)e);
            RDBCorePlugin.getDefault().getLog().log((IStatus)status);
            ConnectionInfoImpl info = (ConnectionInfoImpl)this.conection.getConnectionInfo();
            info.onSQLException(this.conection, e);
            throw e;
        }
    }

    public int executeUpdate(String arg0) throws SQLException {
        return this.statement.executeUpdate(arg0);
    }

    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return this.statement.executeUpdate(arg0, arg1);
    }

    public Connection getConnection() throws SQLException {
        return this.conection;
    }

    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    public boolean getMoreResults(int arg0) throws SQLException {
        return this.statement.getMoreResults(arg0);
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    public int hashCode() {
        return this.statement.hashCode();
    }

    public void setCursorName(String arg0) throws SQLException {
        this.statement.setCursorName(arg0);
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.statement.setEscapeProcessing(arg0);
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.statement.setFetchDirection(arg0);
    }

    public void setFetchSize(int arg0) throws SQLException {
        this.statement.setFetchSize(arg0);
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        this.statement.setMaxFieldSize(arg0);
    }

    public void setMaxRows(int arg0) throws SQLException {
        this.statement.setMaxRows(arg0);
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        this.statement.setQueryTimeout(arg0);
    }

    public String toString() {
        return this.statement.toString();
    }

    private void notifySQLExceptionHandler(SQLException sqlexception) {
        ArrayList handlers = this.getSQLExceptionHandler();
        int i = 0;
        while (i < handlers.size()) {
            SQLExceptionHandler handler = (SQLExceptionHandler)handlers.get(i);
            handler.handleException(sqlexception);
            ++i;
        }
    }

    private ArrayList getSQLExceptionHandler() {
        if (handers != null) {
            return handers;
        }
        handers = new ArrayList();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "sqlexceptionHandler");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("handler")) {
                    try {
                        SQLExceptionHandler handler = (SQLExceptionHandler)configElements[j].createExecutableExtension("class");
                        handers.add(handler);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the exception handler ", (Throwable)e);
                        RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
                ++j;
            }
            ++i;
        }
        return handers;
    }
}

