/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.internal.derby.ddl;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.apache.internal.derby.ddl.DerbyDdlBuilder;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;

public class DerbyDdlBuilder101
extends DerbyDdlBuilder {
    protected static final String NO_CASCADE = "NO CASCADE";

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + " ";
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = String.valueOf(statement) + "AFTER";
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = String.valueOf(statement) + "NO CASCADE BEFORE";
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = String.valueOf(statement) + "INSTEAD OF";
        }
        statement = String.valueOf(statement) + " ";
        if (trigger.isDeleteType()) {
            statement = String.valueOf(statement) + "DELETE";
        } else if (trigger.isInsertType()) {
            statement = String.valueOf(statement) + "INSERT";
        } else if (trigger.isUpdateType()) {
            statement = String.valueOf(statement) + "UPDATE";
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = String.valueOf(statement) + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = String.valueOf(statement) + column.getName();
                    if (!it.hasNext()) continue;
                    statement = String.valueOf(statement) + ", ";
                }
            }
        }
        statement = String.valueOf(statement) + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        trigger.getNewTable();
        trigger.getOldTable();
        if (newRow != null && newRow.length() != 0) {
            statement = String.valueOf(statement) + "REFERENCING NEW AS " + newRow + NEWLINE;
        }
        if (oldRow != null && oldRow.length() != 0) {
            statement = String.valueOf(statement) + "REFERENCING OLD AS " + oldRow + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? String.valueOf(statement) + "FOR EACH ROW MODE DB2SQL" + NEWLINE : String.valueOf(statement) + "FOR EACH STATEMENT MODE DB2SQL" + NEWLINE;
        for (SQLStatement s : trigger.getActionStatement()) {
            statement = String.valueOf(statement) + s.getSQL();
        }
        return statement;
    }
}

