/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;

public class FilterHelper {
    public static final FilterHelper INSTANCE = new FilterHelper();
    private Map dbCollection = new HashMap();

    private FilterHelper() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core.ui", "filterInformation");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("filterInformation")) {
                    String vendor = configElements[j].getAttribute("vendor");
                    String version = configElements[j].getAttribute("version");
                    IConfigurationElement[] configElementsObjectType = configElements[j].getChildren("object");
                    Vector<String> objectType = new Vector<String>();
                    int k = 0;
                    while (k < configElementsObjectType.length) {
                        objectType.add(configElementsObjectType[k].getAttribute("type"));
                        ++k;
                    }
                    Boolean temp = new Boolean(configElements[j].getAttribute("supportsMultiplePredicates"));
                    boolean supportsMultiplePredicates = temp;
                    if (supportsMultiplePredicates) {
                        if (this.dbCollection.containsKey(String.valueOf(vendor) + " " + version)) {
                            Object obj = this.dbCollection.get(String.valueOf(vendor) + " " + version);
                            Vector type = (Vector)obj;
                            int m = 0;
                            while (m < objectType.size()) {
                                type.add(objectType.get(m));
                                ++m;
                            }
                            this.dbCollection.put(String.valueOf(vendor) + " " + version, type);
                        } else {
                            this.dbCollection.put(String.valueOf(vendor) + " " + version, objectType);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean supportsMultiplePredicatesMode(IAdaptable element) {
        IVirtualNode virtualNodeAdapter = (IVirtualNode)element.getAdapter(IVirtualNode.class);
        if (virtualNodeAdapter != null) {
            IVirtualNode virtualNode = virtualNodeAdapter;
            ConnectionInfo connectionInfo = virtualNode.getParentConnection();
            String vendor = connectionInfo.getDatabaseDefinition().getProduct();
            String version = connectionInfo.getDatabaseDefinition().getVersion();
            if (this.dbCollection.containsKey(String.valueOf(vendor) + " " + version)) {
                Vector objectType = (Vector)this.dbCollection.get(String.valueOf(vendor) + " " + version);
                int i = 0;
                while (i < objectType.size()) {
                    if (virtualNode.getClass().getInterfaces()[0].getName().equals(objectType.get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }
}

