/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.ProfileExtensionProvider;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;
import org.eclipse.datatools.connectivity.internal.security.SecurityManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConnectionProfileMgmt {
    public static final String FILENAME = "ServerProfiles.dat";
    public static final String BACKUP_FILENAME = "ServerProfiles.bak";
    public static final String DEFAULTCP_FILENAME = "WorkSpaceServerConnectionProfiles.xml";
    private static final String ROOTNAME = "DataTools.ServerProfiles";
    private static final String CHILDNAME = "profile";
    private static final String PROFILENAME = "name";
    private static final String PROFILEDESC = "desc";
    private static final String PROFILEAUTOCONNECT = "autoconnect";
    private static final String PROFILEPARENT = "parent";
    private static final String PROVIDERID = "providerID";
    private static final String PROPKEYS = "keys";
    private static final String PROPPREFIX = "prop_";
    private static final String PROPDELIM = " ";
    private static final String LITERAL_YES = "Yes";
    private static final String LITERAL_NO = "No";
    private static final String PROFILEID = "id";
    private static final String PROPERTYTAG = "property";
    private static final String PROPERTYNAMEATTR = "name";
    private static final String PROPERTYVALUEATTR = "value";
    private static final String BASEPROPERTIESTAG = "baseproperties";
    private static final String VERSIONATTR = "version";
    private static final String VERSIONSTR = "1.0";
    private static final String DRIVERREFTAG = "driverreference";
    private static final String DRIVERNAMEATTR = "driverName";
    private static final String DRIVERTYPEIDATTR = "driverTypeID";
    private static IPath storageLocation = null;
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;
    private static TransformerFactory transFactory = null;
    private static Transformer transformer = null;

    private static Properties keysToProperties(Element elem) {
        Properties props = new Properties();
        String keys = elem.getAttribute(PROPKEYS);
        StringTokenizer st = new StringTokenizer(keys, PROPDELIM);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String value = elem.getAttribute(PROPPREFIX + key);
            props.put(key, value);
        }
        return props;
    }

    public static void saveCPs(IConnectionProfile[] cps) throws CoreException {
        ConnectionProfileMgmt.saveCPs(cps, ConnectionProfileMgmt.getStorageLocation().append(FILENAME).toFile(), SecurityManager.getInstance().getDefaultCipherProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCPs(IConnectionProfile[] cps, File file, ICipherProvider isp) throws CoreException {
        try {
            Document document;
            DocumentBuilder builder;
            DocumentBuilder documentBuilder = builder = ConnectionProfileMgmt.getDocumentBuilder();
            synchronized (documentBuilder) {
                document = builder.newDocument();
            }
            Element rootElement = document.createElement(ROOTNAME);
            document.appendChild(rootElement);
            if (!file.exists()) {
                file.createNewFile();
            }
            OutputStream out = null;
            FileOutputStream outs = new FileOutputStream(file);
            Writer writer = null;
            try {
                Transformer transformer;
                out = isp != null ? new CipherOutputStream(outs, isp.createEncryptionCipher()) : outs;
                OutputStreamWriter outw = new OutputStreamWriter(out, "UTF-8");
                writer = new BufferedWriter(outw);
                ConnectionProfileMgmt.writeCPToXML1_0(cps, document, rootElement);
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(outw);
                Transformer transformer2 = transformer = ConnectionProfileMgmt.getTransformer();
                synchronized (transformer2) {
                    transformer.transform(source, result);
                    try {
                        writer.close();
                        writer = null;
                    }
                    catch (IOException e) {
                        writer = null;
                        throw e;
                    }
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (DOMException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (GeneralSecurityException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
    }

    private static void writeCPToXML1_0(IConnectionProfile[] cps, Document document, Element rootElement) {
        rootElement.setAttribute(VERSIONATTR, VERSIONSTR);
        int i = 0;
        while (i < cps.length) {
            Properties diprops;
            String jarList;
            DriverInstance di;
            String value;
            String key;
            Properties props;
            String driverID;
            boolean hasJarList;
            boolean hasDriverReference;
            Element child;
            IConnectionProfile cp;
            block17: {
                cp = cps[i];
                child = document.createElement(CHILDNAME);
                child.setAttribute("name", cp.getName());
                child.setAttribute(PROFILEDESC, cp.getDescription());
                child.setAttribute(PROFILEAUTOCONNECT, ((ConnectionProfile)cp).isAutoConnect() ? LITERAL_YES : LITERAL_NO);
                child.setAttribute(PROVIDERID, cp.getProviderId());
                child.setAttribute(PROFILEID, cp.getInstanceID());
                hasDriverReference = false;
                hasJarList = false;
                driverID = null;
                props = cp.getBaseProperties();
                try {
                    props = ((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook().getPersitentProperties(props);
                }
                catch (Exception e) {
                    if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block17;
                    System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookSaveError", new Object[]{cp.getName(), cp.getProviderId()}));
                    e.printStackTrace();
                }
            }
            Element baseProps = document.createElement(BASEPROPERTIESTAG);
            Enumeration<?> enu = props.propertyNames();
            while (enu.hasMoreElements()) {
                key = (String)enu.nextElement();
                value = props.getProperty(key);
                if (key.equals("org.eclipse.datatools.connectivity.driverDefinitionID")) {
                    driverID = value;
                    hasDriverReference = true;
                }
                if (key.equals("jarList")) {
                    hasJarList = false;
                }
                ConnectionProfileMgmt.appendPropertyToElement(document, baseProps, key, value);
            }
            child.appendChild(baseProps);
            for (Map.Entry me : ((ConnectionProfile)cp).getPropertiesMap().entrySet()) {
                Element extraChild;
                block18: {
                    String type = (String)me.getKey();
                    if (type.equals(cp.getProviderId()) || type.equals(BASEPROPERTIESTAG) || type.equals(DRIVERREFTAG)) continue;
                    props = (Properties)me.getValue();
                    extraChild = document.createElement(type);
                    if (props == null) {
                        props = new Properties();
                    }
                    try {
                        ProfileExtensionProvider pep = (ProfileExtensionProvider)cp.getProfileExtensions().get(type);
                        if (pep != null) {
                            props = pep.getPropertiesPersistenceHook().getPersitentProperties(props);
                        }
                    }
                    catch (Exception e) {
                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block18;
                        System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookSaveError", new Object[]{cp.getName(), type}));
                        e.printStackTrace();
                    }
                }
                Enumeration<?> enu2 = props.propertyNames();
                while (enu2.hasMoreElements()) {
                    key = (String)enu2.nextElement();
                    value = props.getProperty(key);
                    if (key.equals("org.eclipse.datatools.connectivity.driverDefinitionID")) {
                        driverID = value;
                        hasDriverReference = true;
                    }
                    ConnectionProfileMgmt.appendPropertyToElement(document, extraChild, key, value);
                }
                child.appendChild(extraChild);
            }
            if (!hasJarList && hasDriverReference && driverID != null && (di = DriverManager.getInstance().getDriverInstanceByID(driverID)) != null && (jarList = (diprops = di.getPropertySet().getBaseProperties()).getProperty("jarList")) != null) {
                ConnectionProfileMgmt.appendPropertyToElement(document, baseProps, "jarList", jarList);
            }
            if (hasDriverReference && driverID != null) {
                Element driverElem = document.createElement(DRIVERREFTAG);
                DriverInstance di2 = DriverManager.getInstance().getDriverInstanceByID(driverID);
                if (di2 != null) {
                    String driverName = di2.getName();
                    if (di2.getTemplate() != null) {
                        String driverType = di2.getTemplate().getId();
                        ConnectionProfileMgmt.appendPropertyToElement(document, driverElem, DRIVERNAMEATTR, driverName);
                        ConnectionProfileMgmt.appendPropertyToElement(document, driverElem, DRIVERTYPEIDATTR, driverType);
                        child.appendChild(driverElem);
                    }
                }
            }
            rootElement.appendChild(child);
            ++i;
        }
    }

    private static void appendPropertyToElement(Document document, Element parent, String key, String value) {
        Element propElem = document.createElement(PROPERTYTAG);
        propElem.setAttribute("name", key);
        propElem.setAttribute(PROPERTYVALUEATTR, value);
        parent.appendChild(propElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IConnectionProfile loadCP(String cpName) throws CoreException {
        File file;
        block10: {
            IPath path = ConnectionProfileMgmt.getStorageLocation();
            path = path.append(FILENAME);
            file = path.toFile();
            if (file.exists()) break block10;
            return null;
        }
        try {
            Document document;
            DocumentBuilder builder;
            FileInputStream is = new FileInputStream(file);
            InputSource source = new InputSource(is);
            source.setEncoding("UTF-8");
            DocumentBuilder documentBuilder = builder = ConnectionProfileMgmt.getDocumentBuilder();
            synchronized (documentBuilder) {
                document = builder.parse(source);
            }
            ConnectionProfile cp = null;
            NodeList nl = document.getElementsByTagName(CHILDNAME);
            int i = 0;
            while (i < nl.getLength()) {
                Element elem;
                Node node = nl.item(i);
                if (node instanceof Element && (elem = (Element)node).getAttribute("name").equals(cpName) && (cp = new ConnectionProfile(elem.getAttribute("name"), elem.getAttribute(PROFILEDESC), elem.getAttribute(PROVIDERID), elem.getAttribute(PROFILEPARENT), LITERAL_YES.equals(elem.getAttribute(PROFILEAUTOCONNECT)), elem.getAttribute(PROFILEID))).getProvider() != null) {
                    cp.setBaseProperties(ConnectionProfileMgmt.keysToProperties(elem));
                    if (cp.getProfileExtensions().size() == 0) break;
                    for (Map.Entry me : cp.getProfileExtensions().entrySet()) {
                        String type = (String)me.getKey();
                        Node xmlExtraChild = elem.getFirstChild();
                        if (xmlExtraChild == null || !elem.getTagName().equals(type)) continue;
                        cp.setProperties(type, ConnectionProfileMgmt.keysToProperties((Element)xmlExtraChild));
                    }
                    break;
                }
                ++i;
            }
            cp.setCreated();
            return cp;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
    }

    public static IConnectionProfile[] loadCPs(File file) throws CoreException {
        try {
            if (!ConnectionProfileMgmt.isEncrypted(file)) {
                return ConnectionProfileMgmt.loadCPs(file, null);
            }
            return ConnectionProfileMgmt.loadCPs(file, SecurityManager.getInstance().getDefaultCipherProvider());
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
    }

    public static boolean isEncrypted(File file) throws IOException {
        byte[] bytes = new byte[5];
        char[] xml = new char[]{'<', '?', 'x', 'm', 'l'};
        FileInputStream fis = new FileInputStream(file);
        fis.read(bytes);
        fis.close();
        boolean isXML = true;
        int i = 0;
        while (isXML && i < 5) {
            isXML = bytes[i] == xml[i];
            ++i;
        }
        return !isXML;
    }

    private static Properties keysElementsToProperties(Element elem) {
        Properties props = new Properties();
        NodeList nl = elem.getElementsByTagName(PROPERTYTAG);
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element) {
                Element property = (Element)node;
                String key = property.getAttribute("name");
                String value = property.getAttribute(PROPERTYVALUEATTR);
                props.put(key, value);
            }
            ++i;
        }
        return props;
    }

    private static boolean readCPsFromXML1_0(ArrayList cps, Document document) {
        if (cps == null) {
            cps = new ArrayList<ConnectionProfile>();
        }
        boolean updatedIDs = false;
        NodeList nl = document.getElementsByTagName(CHILDNAME);
        int i = 0;
        while (i < nl.getLength()) {
            Element elem;
            ConnectionProfile cp;
            Node node = nl.item(i);
            if (node instanceof Element && (cp = new ConnectionProfile((elem = (Element)node).getAttribute("name"), elem.getAttribute(PROFILEDESC), elem.getAttribute(PROVIDERID), elem.getAttribute(PROFILEPARENT), LITERAL_YES.equals(elem.getAttribute(PROFILEAUTOCONNECT)), elem.getAttribute(PROFILEID))).getProvider() != null) {
                NodeList nl2 = elem.getElementsByTagName(BASEPROPERTIESTAG);
                if (nl.getLength() > 0) {
                    Element baseProps = null;
                    int j = 0;
                    while (j < nl2.getLength()) {
                        Element el;
                        Node testnode = nl2.item(j);
                        if (testnode instanceof Element && (el = (Element)testnode).getTagName().equals(BASEPROPERTIESTAG)) {
                            baseProps = el;
                            break;
                        }
                        ++j;
                    }
                    if (baseProps != null) {
                        Properties props;
                        block27: {
                            props = ConnectionProfileMgmt.keysElementsToProperties(baseProps);
                            try {
                                props = ((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook().populateTransientProperties(props);
                            }
                            catch (Exception e) {
                                if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block27;
                                System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), cp.getProviderId()}));
                                e.printStackTrace();
                            }
                        }
                        cp.setBaseProperties(props);
                    }
                }
                NodeList extElements = elem.getChildNodes();
                int extIndex = 0;
                int extCount = extElements.getLength();
                while (extIndex < extCount) {
                    String type;
                    Node extNode = extElements.item(extIndex);
                    if (extNode.getNodeType() == 1 && !(type = extNode.getNodeName()).equals(BASEPROPERTIESTAG)) {
                        Properties props;
                        if (type.equals(DRIVERREFTAG)) {
                            props = ConnectionProfileMgmt.keysElementsToProperties((Element)extNode);
                            String driverName = props.getProperty(DRIVERNAMEATTR);
                            String driverTypeID = props.getProperty(DRIVERTYPEIDATTR);
                            String driverID = "";
                            boolean existingDriverHasName = false;
                            DriverInstance[] testDI = DriverManager.getInstance().getDriverInstancesByName(driverName);
                            if (testDI != null) {
                                int index = 0;
                                while (index < testDI.length) {
                                    if (testDI[index].getTemplate().getId().equalsIgnoreCase(driverTypeID)) {
                                        existingDriverHasName = true;
                                    }
                                    ++index;
                                }
                            }
                            if (testDI == null || testDI != null && !existingDriverHasName) {
                                DriverInstance di = DriverManager.getInstance().createNewDriverInstance(driverTypeID, driverName, new String());
                                if (di != null) {
                                    driverID = di.getId();
                                    Properties baseProps = cp.getBaseProperties();
                                    baseProps.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", driverID);
                                    cp.setBaseProperties(baseProps);
                                    String jarList = cp.getBaseProperties().getProperty("jarList");
                                    String driverClass = cp.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
                                    if (jarList != null && jarList.trim().length() > 0 || driverClass != null && driverClass.trim().length() > 0) {
                                        Properties diprops = di.getPropertySet().getBaseProperties();
                                        if (jarList != null && jarList.trim().length() > 0) {
                                            diprops.setProperty("jarList", jarList);
                                        }
                                        if (driverClass != null && driverClass.trim().length() > 0) {
                                            diprops.setProperty("org.eclipse.datatools.connectivity.db.driverClass", driverClass);
                                        }
                                        di.getPropertySet().setBaseProperties(diprops);
                                        DriverManager.getInstance().removeDriverInstance(di.getId());
                                        System.gc();
                                        DriverManager.getInstance().addDriverInstance(di);
                                    } else {
                                        String message = ConnectivityPlugin.getDefault().getResourceString("drivermarker.import.error", new String[]{cp.getName()});
                                        ConnectivityPlugin.getDefault().log(message);
                                        ConnectionProfileMgmt.removeOldDriverProblemMarkers(di.getName());
                                        ConnectionProfileMgmt.addDriverProblemMarker(di.getName(), message);
                                    }
                                    updatedIDs = true;
                                } else if (ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) {
                                    String message = ConnectivityPlugin.getDefault().getResourceString("trace.error.drivermigration", new Object[]{cp.getName(), driverTypeID});
                                    System.err.println(message);
                                    ConnectivityPlugin.getDefault().log(message);
                                }
                            }
                        } else {
                            block28: {
                                props = ConnectionProfileMgmt.keysElementsToProperties((Element)extNode);
                                try {
                                    ProfileExtensionProvider pep = (ProfileExtensionProvider)cp.getProfileExtensions().get(type);
                                    if (pep != null) {
                                        props = pep.getPropertiesPersistenceHook().populateTransientProperties(props);
                                    }
                                }
                                catch (Exception e) {
                                    if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block28;
                                    System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), type}));
                                    e.printStackTrace();
                                }
                            }
                            cp.setProperties(type, props);
                        }
                    }
                    ++extIndex;
                }
                cp.setCreated();
                cps.add(cp);
                updatedIDs = elem.getAttribute(PROFILEID) == null || updatedIDs;
            }
            ++i;
        }
        return updatedIDs;
    }

    public static IConnectionProfile[] importCPs(File file, ICipherProvider isp, boolean isOverwrite) throws CoreException, ConnectionProfileException {
        IConnectionProfile[] newConnectionProfiles = new IConnectionProfile[]{};
        newConnectionProfiles = ConnectionProfileMgmt.loadCPs(file, isp);
        int index = 0;
        while (index < newConnectionProfiles.length) {
            IConnectionProfile profile;
            IConnectionProfile currentConnectionProfile = newConnectionProfiles[index];
            if (isOverwrite && (profile = ProfileManager.getInstance().getProfileByName(currentConnectionProfile.getName())) != null) {
                ProfileManager.getInstance().deleteProfile(profile);
            }
            ProfileManager.getInstance().addProfile(currentConnectionProfile);
            Properties baseProperties = currentConnectionProfile.getBaseProperties();
            String jarList = baseProperties.getProperty("jarList", null);
            String driverDefinitionID = baseProperties.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID", null);
            String driverTemplateID = baseProperties.getProperty("org.eclipse.datatools.connectivity.drivers.defnType", null);
            TemplateDescriptor templateDescriptor = TemplateDescriptor.getDriverTemplateDescriptor(driverTemplateID);
            DriverInstance driverInstance = DriverManager.getInstance().getDriverInstanceByID(driverDefinitionID);
            if (driverInstance == null && jarList != null || driverInstance != null && jarList != null && !jarList.equals(driverInstance.getJarList())) {
                DriverInstance[] driverInstances = DriverManager.getInstance().getDriverInstancesByTemplate(driverTemplateID);
                String existingDriverDefinitionID = null;
                int driverIndex = 0;
                while (driverIndex < driverInstances.length) {
                    if (jarList.equals(driverInstances[driverIndex].getJarList())) {
                        existingDriverDefinitionID = driverInstances[driverIndex].getId();
                        break;
                    }
                    ++driverIndex;
                }
                if (existingDriverDefinitionID != null) {
                    baseProperties.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", existingDriverDefinitionID);
                    currentConnectionProfile.setProperties(currentConnectionProfile.getProviderId(), baseProperties);
                } else {
                    String driverDefinitionNameBase = currentConnectionProfile.getName();
                    if (templateDescriptor != null) {
                        driverDefinitionNameBase = templateDescriptor.getDefaultDefinitionName();
                    }
                    String driverClass = baseProperties.getProperty("org.eclipse.datatools.connectivity.db.driverClass").toString();
                    String uniqueDriverInstanceName = ConnectionProfileMgmt.generateUniqueDriverDefinitionName(driverDefinitionNameBase);
                    DriverInstance newDriverInstance = DriverManager.getInstance().createNewDriverInstance(driverTemplateID, uniqueDriverInstanceName, jarList, driverClass);
                    if (newDriverInstance != null) {
                        baseProperties.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", newDriverInstance.getId());
                        currentConnectionProfile.setProperties(currentConnectionProfile.getProviderId(), baseProperties);
                    }
                }
            }
            ++index;
        }
        return newConnectionProfiles;
    }

    private static String generateUniqueDriverDefinitionName(String baseDriverInstanceName) {
        int index = 0;
        if (baseDriverInstanceName == null) {
            baseDriverInstanceName = "0";
        }
        String testName = baseDriverInstanceName;
        while (DriverManager.getInstance().getDriverInstanceByName(testName) != null) {
            testName = String.valueOf(baseDriverInstanceName) + String.valueOf(++index);
        }
        return testName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IConnectionProfile[] loadCPs(File file, ICipherProvider isp) throws CoreException {
        IConnectionProfile[] retVal = null;
        InputStream is = null;
        try {
            if (!file.exists()) {
                IConnectionProfile[] iConnectionProfileArray = new IConnectionProfile[]{};
                return iConnectionProfileArray;
            }
            try {
                FileInputStream fis = new FileInputStream(file);
                is = isp != null ? new CipherInputStream(fis, isp.createDecryptionCipher()) : fis;
                InputSource source = new InputSource(is);
                source.setEncoding("UTF-8");
                Document document = null;
                try {
                    DocumentBuilder builder;
                    DocumentBuilder documentBuilder = builder = ConnectionProfileMgmt.getDocumentBuilder();
                    synchronized (documentBuilder) {
                        document = builder.parse(source);
                    }
                }
                catch (SAXException e) {
                    try {
                        DocumentBuilder builder;
                        DocumentBuilder documentBuilder = builder = ConnectionProfileMgmt.getDocumentBuilder(true);
                        synchronized (documentBuilder) {
                            document = builder.parse(source);
                        }
                    }
                    catch (SAXException sAXException) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
                    }
                }
                ArrayList<ConnectionProfile> cps = new ArrayList<ConnectionProfile>();
                boolean updatedIDs = false;
                String version = document.getDocumentElement().getAttribute(VERSIONATTR);
                if (version != null && version.equals(VERSIONSTR)) {
                    updatedIDs = ConnectionProfileMgmt.readCPsFromXML1_0(cps, document);
                } else {
                    NodeList nl = document.getElementsByTagName(CHILDNAME);
                    int i = 0;
                    while (i < nl.getLength()) {
                        Element elem;
                        ConnectionProfile cp;
                        Node node = nl.item(i);
                        if (node instanceof Element && (cp = new ConnectionProfile((elem = (Element)node).getAttribute("name"), elem.getAttribute(PROFILEDESC), elem.getAttribute(PROVIDERID), elem.getAttribute(PROFILEPARENT), LITERAL_YES.equals(elem.getAttribute(PROFILEAUTOCONNECT)), elem.getAttribute(PROFILEID))).getProvider() != null) {
                            Properties props;
                            block39: {
                                props = ConnectionProfileMgmt.keysToProperties(elem);
                                try {
                                    if (((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook() != null) {
                                        props = ((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook().populateTransientProperties(props);
                                    }
                                }
                                catch (Exception e) {
                                    if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block39;
                                    System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), cp.getProviderId()}));
                                    e.printStackTrace();
                                }
                            }
                            cp.setBaseProperties(props);
                            NodeList extElements = elem.getChildNodes();
                            int extIndex = 0;
                            int extCount = extElements.getLength();
                            while (extIndex < extCount) {
                                Node extNode = extElements.item(extIndex);
                                if (extNode.getNodeType() == 1) {
                                    String type;
                                    block40: {
                                        type = extNode.getNodeName();
                                        props = ConnectionProfileMgmt.keysToProperties((Element)extNode);
                                        try {
                                            ProfileExtensionProvider pep = (ProfileExtensionProvider)cp.getProfileExtensions().get(type);
                                            if (pep != null) {
                                                props = pep.getPropertiesPersistenceHook().populateTransientProperties(props);
                                            }
                                        }
                                        catch (Exception e) {
                                            if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block40;
                                            System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), type}));
                                            e.printStackTrace();
                                        }
                                    }
                                    cp.setProperties(type, props);
                                }
                                ++extIndex;
                            }
                            cp.setCreated();
                            cps.add(cp);
                            updatedIDs = elem.getAttribute(PROFILEID) == null || updatedIDs;
                        }
                        ++i;
                    }
                }
                retVal = cps.toArray(new IConnectionProfile[cps.size()]);
                if (updatedIDs) {
                    ConnectionProfileMgmt.saveCPs(retVal, file, isp);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
            }
            catch (GeneralSecurityException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
                }
            }
        }
        return retVal;
    }

    public static IPath getStorageLocation() {
        if (storageLocation == null) {
            return ConnectivityPlugin.getDefault().getStateLocation();
        }
        return storageLocation;
    }

    public static void setStorageLocation(IPath location) {
        storageLocation = location;
    }

    private static DocumentBuilder getDocumentBuilder() {
        return ConnectionProfileMgmt.getDocumentBuilder(false);
    }

    private static DocumentBuilder getDocumentBuilder(boolean reset) {
        if (documentBuilder == null || reset) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return documentBuilder;
    }

    private static Transformer getTransformer() {
        if (transformer == null) {
            transFactory = TransformerFactory.newInstance();
            try {
                transformer = transFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return transformer;
    }

    private static void addDriverProblemMarker(String name, String message) {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("message", ConnectivityPlugin.getDefault().getResourceString("drivermarker.error", new String[]{name, message}));
        map.put("severity", new Integer(2));
        map.put("location", name);
        map.put("transient", Boolean.FALSE.toString());
        try {
            IMarker marker = resource.createMarker("org.eclipse.datatools.connectivity.ui.driverProblem");
            marker.setAttributes(map);
        }
        catch (CoreException coreException) {}
    }

    private static void removeOldDriverProblemMarkers(String name) {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] markers = resource.findMarkers("org.eclipse.datatools.connectivity.ui.driverProblem", true, 2);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getAttribute("location", new String()).equals(name)) {
                    markers[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }
}

