/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCProcedure;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCUserDefinedFunction;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EClass;

public class JDBCRoutineLoader
extends JDBCBaseLoader {
    public static final String COLUMN_PROCEDURE_NAME = "PROCEDURE_NAME";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_PROCEDURE_TYPE = "PROCEDURE_TYPE";
    private IRoutineFactory mUserDefinedFunctionFactory;
    private IRoutineFactory mProcedureFactory;

    public JDBCRoutineLoader(ICatalogObject catalogObject) {
        this(catalogObject, new SchemaObjectFilterProvider("DatatoolsSPFilterPredicate"));
    }

    public JDBCRoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        this(catalogObject, connectionFilterProvider, new UserDefinedFunctionFactory(), new ProcedureFactory());
    }

    public JDBCRoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider, IRoutineFactory udfFactory, IRoutineFactory spFactory) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Schema);
        this.mUserDefinedFunctionFactory = udfFactory;
        this.mProcedureFactory = spFactory;
    }

    public List loadRoutines() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadRoutines(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadRoutines(List containmentList, Collection existingRoutines) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            while (rs.next()) {
                String routineName = rs.getString(COLUMN_PROCEDURE_NAME);
                if (routineName == null || this.isFiltered(routineName)) continue;
                Routine routine = (Routine)this.getAndRemoveSQLObject(existingRoutines, routineName);
                if (routine == null) {
                    routine = this.processRow(rs);
                    if (routine == null) continue;
                    containmentList.add(routine);
                    continue;
                }
                if (this.isProcedure(rs)) {
                    this.mProcedureFactory.initialize(routine, rs);
                } else {
                    this.mUserDefinedFunctionFactory.initialize(routine, rs);
                }
                containmentList.add(routine);
                if (!(routine instanceof ICatalogObject)) continue;
                ((ICatalogObject)routine).refresh();
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearRoutines(List routines) {
        routines.clear();
    }

    public IRoutineFactory getProcedureFactory() {
        return this.mProcedureFactory;
    }

    public void setProcedureFactory(IRoutineFactory procedureFactory) {
        this.mProcedureFactory = procedureFactory;
    }

    public IRoutineFactory getUserDefinedFunctionFactory() {
        return this.mUserDefinedFunctionFactory;
    }

    public void setUserDefinedFunctionFactory(IRoutineFactory userDefinedFunctionFactory) {
        this.mUserDefinedFunctionFactory = userDefinedFunctionFactory;
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Schema schema = this.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getProcedures(schema.getCatalog().getName(), schema.getName(), this.getJDBCFilterPattern());
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getProcedures()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Routine processRow(ResultSet rs) throws SQLException {
        IRoutineFactory routineFactory = this.isProcedure(rs) ? this.mProcedureFactory : this.mUserDefinedFunctionFactory;
        return routineFactory.createRoutine(rs);
    }

    protected Schema getSchema() {
        return (Schema)this.getCatalogObject();
    }

    protected boolean isProcedure(ResultSet rs) throws SQLException {
        return rs.getShort(COLUMN_PROCEDURE_TYPE) == 1;
    }

    public static interface IRoutineFactory {
        public EClass getRoutineEClass();

        public Routine createRoutine(ResultSet var1) throws SQLException;

        public void initialize(Routine var1, ResultSet var2) throws SQLException;
    }

    public static class ProcedureFactory
    implements IRoutineFactory {
        public EClass getRoutineEClass() {
            return SQLRoutinesPackage.eINSTANCE.getProcedure();
        }

        public Routine createRoutine(ResultSet rs) throws SQLException {
            Routine retVal = this.newRoutine();
            this.initialize(retVal, rs);
            return retVal;
        }

        protected Routine newRoutine() {
            return new JDBCProcedure();
        }

        public void initialize(Routine routine, ResultSet rs) throws SQLException {
            routine.setName(rs.getString(JDBCRoutineLoader.COLUMN_PROCEDURE_NAME));
            routine.setDescription(rs.getString(JDBCRoutineLoader.COLUMN_REMARKS));
        }
    }

    public static class UserDefinedFunctionFactory
    extends ProcedureFactory {
        public EClass getRoutineEClass() {
            return SQLRoutinesPackage.eINSTANCE.getUserDefinedFunction();
        }

        protected Routine newRoutine() {
            return new JDBCUserDefinedFunction();
        }
    }
}

