/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileMigrator;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class ConnectionProfileMigratorBase
implements IConnectionProfileMigrator,
IExecutableExtension {
    private static final String ELEM_PROPERTY_MIGRATION = "propertyMigration";
    private static final String ATTR_OLD_PROPERTY_KEY = "oldPropertyKey";
    private static final String ATTR_NEW_PROPERTY_KEY = "newPropertyKey";
    private static final String ATTR_NEW_VALUE = "newValue";
    private static final String ATTR_NEW_PROVIDER_ID = "newProviderID";
    private Map mPropertyMigrations;
    private Map mDefaults;
    private String mNewProviderID;

    public void performMigration(IConnectionProfile profile) {
        this.applyPropertyMigrations(profile);
    }

    public final String getNewProviderID() {
        return this.mNewProviderID;
    }

    protected final void applyPropertyMigrations(IConnectionProfile profile) {
        Properties props = profile.getProperties(this.mNewProviderID);
        if (props == null) {
            props = new Properties();
        }
        for (Map.Entry entry : this.mPropertyMigrations.entrySet()) {
            String oldKey = (String)entry.getKey();
            String newKey = (String)entry.getValue();
            String value = props.getProperty(oldKey);
            props.remove(oldKey);
            if (newKey == null || value == null) continue;
            props.setProperty(newKey, value);
        }
        for (Map.Entry entry : this.mDefaults.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            props.setProperty((String)entry.getKey(), value);
        }
        profile.setProperties(this.mNewProviderID, props);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.mNewProviderID = config.getAttribute(ATTR_NEW_PROVIDER_ID);
        if (this.mNewProviderID != null && this.mNewProviderID.length() < 1) {
            IConfigurationElement parentElement = (IConfigurationElement)config.getParent();
            if ("connectionProfile".equals(parentElement.getName())) {
                this.mNewProviderID = parentElement.getAttribute("id");
            } else {
                if (!"profileExtension".equals(parentElement.getName())) {
                    Status status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("migration.error.unknownParentElement", new Object[]{parentElement.getName()}), null);
                    throw new CoreException((IStatus)status);
                }
                this.mNewProviderID = parentElement.getAttribute("id");
            }
        } else if (!ConnectionProfileManager.getInstance().getProviders().containsKey(this.mNewProviderID)) {
            Status status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("migration.error.providerDoesNotExist", new Object[]{this.mNewProviderID}), null);
            throw new CoreException((IStatus)status);
        }
        this.parsePropertyMigrations(config);
    }

    private void parsePropertyMigrations(IConfigurationElement config) throws CoreException {
        IConfigurationElement[] propertyMigrations = config.getChildren(ELEM_PROPERTY_MIGRATION);
        this.mPropertyMigrations = new HashMap(propertyMigrations.length);
        this.mDefaults = new HashMap(propertyMigrations.length);
        if (propertyMigrations == null || propertyMigrations.length == 0) {
            return;
        }
        int index = 0;
        int count = propertyMigrations.length;
        while (index < count) {
            String oldPropertyKey = propertyMigrations[index].getAttribute(ATTR_OLD_PROPERTY_KEY);
            if (oldPropertyKey == null || oldPropertyKey.length() == 0) {
                String newPropertyKey = propertyMigrations[index].getAttribute(ATTR_NEW_PROPERTY_KEY);
                if (newPropertyKey == null || newPropertyKey.length() == 0) {
                    Status status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("migration.error.invalidPropertyMigrationElement"), null);
                    throw new CoreException((IStatus)status);
                }
                String value = propertyMigrations[index].getAttribute(ATTR_NEW_VALUE);
                if (value != null) {
                    this.mDefaults.put(newPropertyKey, value);
                }
            } else {
                this.mPropertyMigrations.put(oldPropertyKey, propertyMigrations[index].getAttribute(ATTR_NEW_PROPERTY_KEY));
            }
            ++index;
        }
    }
}

