/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.SaveDDLUtility;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.FEUiPlugin;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FEConfigurationData;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FESelectFileWizardPage;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FESelectObjectsWizardPage;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FESelectOptionsWizardPage;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FESpecifyExistingConnectionsWizardPage;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FESummaryProperty;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FESummaryWizardPage;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.IGenerateDDL;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.result.GroupSQLResultRunnable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class FEWizard
extends Wizard
implements IGenerateDDL,
IContextProvider {
    private FESelectOptionsWizardPage selectOptionsPage;
    private FESelectObjectsWizardPage selectObjectsPage;
    private FESelectFileWizardPage selectFilePage;
    private FESpecifyExistingConnectionsWizardPage existingConnectionsPage;
    private FESummaryWizardPage summaryPage;
    private static String SELECT_OPTIONS_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectOptionsPage";
    private static String SELECT_OBJECTS_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectObjectsPage";
    private static String SELECT_FILE_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectFilePage";
    private static String EXISTING_CONNECTIONS_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.ExistingConnectionsPage";
    private static String SUMMARY_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SummaryPage";
    private static final String TRUE_SUMMARY_DATA_TEXT = ResourceLoader.INSTANCE.queryString("FEWizard.trueSummaryValueText");
    private static final String FALSE_SUMMARY_DATA_TEXT = ResourceLoader.INSTANCE.queryString("FEWizard.falseSummaryValueText");
    private List selection;
    private DDLGenerator feProvider;
    private DatabaseDefinition databaseDefinition;
    String lastProductValueSet = "";
    String lastVersionValueSet = "";
    private StringWriter writer = new StringWriter();
    private String[] ddlScripts = new String[0];
    private boolean hasGenerated = false;
    private String LINE_RETURN = System.getProperty("line.separator");
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(FEUiPlugin.getDefault().getBundle().getSymbolicName());

    public FEWizard(List selection) {
        this.selection = selection;
        this.setWindowTitle(ResourceLoader.INSTANCE.queryString("FE_WIZARD_TITLEBAR_TEXT"));
        this.setDefaultPageImageDescriptor(ImageDescription.getGenerateDDLWizard());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        Database database = this.getDatabase((EObject)((SQLObject)this.selection.get(0)));
        this.databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database.getVendor(), database.getVersion());
        this.feProvider = this.databaseDefinition.getDDLGenerator();
        FEConfigurationData configurationData = new FEConfigurationData(this.feProvider.getOptions(this.selection.toArray(new SQLObject[this.selection.size()])));
        this.selectOptionsPage = new FESelectOptionsWizardPage(SELECT_OPTIONS_WIZARD_PAGE_NAME, configurationData, new Listener(){

            public void handleEvent(Event event) {
                if (FEWizard.this.selectFilePage != null) {
                    FEWizard.this.selectFilePage.clearDeltaDDL();
                }
            }
        });
        this.addPage((IWizardPage)this.selectOptionsPage);
        this.selectObjectsPage = new FESelectObjectsWizardPage(SELECT_OBJECTS_WIZARD_PAGE_NAME, configurationData, new Listener(){

            public void handleEvent(Event event) {
                if (FEWizard.this.selectFilePage != null) {
                    FEWizard.this.selectFilePage.clearDeltaDDL();
                }
            }
        });
        this.addPage((IWizardPage)this.selectObjectsPage);
        this.selectFilePage = new FESelectFileWizardPage(SELECT_FILE_WIZARD_PAGE_NAME, this.selection);
        this.addPage((IWizardPage)this.selectFilePage);
        this.selectFilePage.setTerminator(this.databaseDefinition.getSQLTerminationCharacter());
        this.existingConnectionsPage = new FESpecifyExistingConnectionsWizardPage(EXISTING_CONNECTIONS_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.existingConnectionsPage);
        this.summaryPage = new FESummaryWizardPage(SUMMARY_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) {
                try {
                    try {
                        FEWizard.this.performDDLGeneration(monitor);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public StringWriter generateDDL() {
        if (this.databaseDefinition.getProduct().equals("Oracle") || this.databaseDefinition.getProduct().equals("DB2 UDB") || this.databaseDefinition.getProduct().equals("DB2 UDB zSeries")) {
            this.LINE_RETURN = "\n";
        }
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    FEWizard.this.writer = new StringWriter();
                    monitor.beginTask("", 5);
                    monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.generatingDDLProgressMessage"));
                    monitor.worked(1);
                    FEWizard.this.hasGenerated = false;
                    FEConfigurationData configurationData = FEWizard.this.selectOptionsPage.getOptions();
                    if (configurationData != null) {
                        try {
                            String fullStatementTermination = "";
                            String statementTerminator = FEWizard.this.selectFilePage.getTerminator();
                            fullStatementTermination = statementTerminator.length() < 2 ? String.valueOf(fullStatementTermination) + statementTerminator + FEWizard.this.LINE_RETURN + FEWizard.this.LINE_RETURN : String.valueOf(fullStatementTermination) + FEWizard.this.LINE_RETURN + statementTerminator + FEWizard.this.LINE_RETURN + FEWizard.this.LINE_RETURN;
                            FEWizard.this.ddlScripts = FEWizard.this.feProvider.generateDDL(FEWizard.this.selection.toArray(new SQLObject[FEWizard.this.selection.size()]), monitor);
                            FEWizard.this.hasGenerated = true;
                            monitor.worked(3);
                            String defaultEditorTermnator = "--<ScriptOptions statementTerminator=\"" + statementTerminator + "\"/>" + FEWizard.this.LINE_RETURN + FEWizard.this.LINE_RETURN;
                            FEWizard.this.writer.write(defaultEditorTermnator);
                            int i = 0;
                            while (i < FEWizard.this.ddlScripts.length) {
                                ((FEWizard)FEWizard.this).ddlScripts[i] = FEWizard.this.ddlScripts[i].trim();
                                if (FEWizard.this.ddlScripts[i].endsWith(statementTerminator)) {
                                    ((FEWizard)FEWizard.this).ddlScripts[i] = FEWizard.this.ddlScripts[i].substring(0, FEWizard.this.ddlScripts[i].length() - statementTerminator.length());
                                }
                                FEWizard.this.writer.write(String.valueOf(FEWizard.this.ddlScripts[i]) + fullStatementTermination);
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.writer;
    }

    public void performDDLGeneration(IProgressMonitor monitor) {
        block13: {
            try {
                try {
                    if (this.hasGenerated) {
                        IConnectionProfile conn;
                        monitor.worked(2);
                        monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.savingDDLProgressMessage"));
                        IFile ddlFile = SaveDDLUtility.getInstance().saveDDLFileAsResource(this.writer, this.selectFilePage.getResourcePath());
                        monitor.worked(4);
                        if (this.selectFilePage.isOpenDDLSelected()) {
                            monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.openingDDLProgressMessage"));
                            if (ddlFile != null) {
                                IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(ddlFile.getName());
                                if (editorDescriptor == null) {
                                    editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("file.txt");
                                }
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(ddlFile), editorDescriptor.getId());
                            }
                        }
                        if (this.selectFilePage.isExecuteSelected() && (conn = this.getDBConnection()) != null && this.ddlScripts != null) {
                            this.executeDDL(this.ddlScripts, conn);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.hasGenerated) {
                        MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 513);
                        box.setMessage(ResourceLoader.INSTANCE.queryString("FEWizard.ddlGenerationErrorMessage"));
                        box.open();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (!this.hasGenerated) {
                    MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 513);
                    box.setMessage(ResourceLoader.INSTANCE.queryString("FEWizard.ddlGenerationErrorMessage"));
                    box.open();
                }
                throw throwable;
            }
            if (!this.hasGenerated) {
                MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 513);
                box.setMessage(ResourceLoader.INSTANCE.queryString("FEWizard.ddlGenerationErrorMessage"));
                box.open();
            }
        }
        monitor.worked(5);
    }

    private void executeDDL(String[] sqlStatements, IConnectionProfile connectionProfile) {
        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(connectionProfile.getName(), "");
        if (databaseIdentifier != null) {
            try {
                GroupSQLResultRunnable job = new GroupSQLResultRunnable(null, sqlStatements, null, null, databaseIdentifier, false, new HashMap(), Messages.BaseExecuteAction_group_exec_title, "Generate DDL");
                job.setName(Messages.BaseExecuteAction_job_title);
                job.setUser(true);
                job.schedule();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.datatools.sqltools.result.resultView");
            }
            catch (Exception exception) {}
        }
    }

    public boolean canFinish() {
        boolean canFinish = false;
        canFinish = this.selectOptionsPage.isPageComplete() && this.selectObjectsPage.isPageComplete() && this.selectFilePage.isPageComplete() && this.summaryPage.isVisible();
        return canFinish;
    }

    public IWizardPage getNextPage(IWizardPage wizardPage) {
        Object nextPage = null;
        String currentProductSet = this.databaseDefinition.getProduct();
        String currentVersionSet = this.databaseDefinition.getVersion();
        if (!this.lastProductValueSet.equals(currentProductSet) || !this.lastVersionValueSet.equals(currentVersionSet)) {
            this.lastProductValueSet = currentProductSet;
            this.lastVersionValueSet = currentVersionSet;
            this.existingConnectionsPage.setAllowedVendor(this.databaseDefinition.getProduct());
            this.existingConnectionsPage.setAllowedVersion(this.databaseDefinition.getVersion());
        }
        nextPage = wizardPage.getName().equals(SELECT_OPTIONS_WIZARD_PAGE_NAME) ? this.selectObjectsPage : (wizardPage.getName().equals(SELECT_OBJECTS_WIZARD_PAGE_NAME) ? this.selectFilePage : (wizardPage.getName().equals(SELECT_FILE_WIZARD_PAGE_NAME) ? (this.selectFilePage.isExecuteSelected() ? this.existingConnectionsPage : this.populateSummaryPage()) : (wizardPage.getName().equals(EXISTING_CONNECTIONS_WIZARD_PAGE_NAME) ? this.populateSummaryPage() : (wizardPage.getName().equals(SUMMARY_WIZARD_PAGE_NAME) ? null : super.getNextPage(wizardPage)))));
        return nextPage;
    }

    private FESummaryWizardPage populateSummaryPage() {
        if (this.summaryPage == null) {
            this.summaryPage = new FESummaryWizardPage(SUMMARY_WIZARD_PAGE_NAME);
            this.addPage((IWizardPage)this.summaryPage);
        }
        EngineeringOption[] options = this.selectOptionsPage.getOptions().getOptions();
        FESummaryProperty[] properties = null;
        Vector<FESummaryProperty> propertiesCollection = new Vector<FESummaryProperty>();
        propertiesCollection.add(new FESummaryProperty(ResourceLoader.INSTANCE.queryString("FEWizard.fileLocationSummaryProperty"), this.selectFilePage.getResourcePath()));
        propertiesCollection.add(new FESummaryProperty(ResourceLoader.INSTANCE.queryString("FEWizard.openDDLForEditingSummaryProperty"), String.valueOf(this.selectFilePage.isOpenDDLSelected())));
        propertiesCollection.add(new FESummaryProperty(ResourceLoader.INSTANCE.queryString("FEWizard.runDDLOnServerSummaryProperty"), this.selectFilePage.isExecuteSelected() ? TRUE_SUMMARY_DATA_TEXT : FALSE_SUMMARY_DATA_TEXT));
        if (this.selectFilePage.isExecuteSelected()) {
            propertiesCollection.add(new FESummaryProperty(ResourceLoader.INSTANCE.queryString("FEWizard.connectionNameSummaryProperty"), this.existingConnectionsPage.getSelectedConnection().getName()));
        }
        propertiesCollection.add(new FESummaryProperty("", ""));
        int index = 0;
        while (index < options.length) {
            propertiesCollection.add(new FESummaryProperty(options[index].getOptionDescription(), String.valueOf(options[index].getBoolean())));
            ++index;
        }
        propertiesCollection.add(new FESummaryProperty("", ""));
        options = this.selectObjectsPage.getOptions().getOptions();
        index = 0;
        while (index < options.length) {
            propertiesCollection.add(new FESummaryProperty(options[index].getOptionDescription(), String.valueOf(options[index].getBoolean())));
            ++index;
        }
        properties = new FESummaryProperty[propertiesCollection.size()];
        propertiesCollection.toArray(properties);
        this.summaryPage.setProperties(properties);
        return this.summaryPage;
    }

    private Database getDatabase(EObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Database) {
            return (Database)object;
        }
        return this.getDatabase(RDBCorePlugin.getDefault().getContainmentService().getContainer(object));
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"GENERATE_DDL_WIZARD", (String)FEUiPlugin.getDefault().getBundle().getSymbolicName()));
    }

    private IConnectionProfile getDBConnection() {
        IConnectionProfile connection = null;
        IConnectionProfile connectionProfile = this.existingConnectionsPage.getSelectedConnection();
        if (connectionProfile != null) {
            connection = this.getActiveConnection(connectionProfile);
        }
        return connection;
    }

    /*
     * Unable to fully structure code
     */
    private IConnectionProfile getActiveConnection(IConnectionProfile connectionProfile) {
        block5: {
            block4: {
                activeConnection = null;
                connection = null;
                connectionStatus = null;
                if (connectionProfile.getConnectionState() != 1) break block4;
                activeConnection = connectionProfile.getManagedConnection("java.sql.Connection").getConnection().getConnectionProfile();
                break block5;
            }
            connectionStatus = connectionProfile.connectWithoutJob();
            if (connectionProfile.getConnectionState() != 1) ** GOTO lbl25
            return connectionProfile.getManagedConnection("java.sql.Connection").getConnection().getConnectionProfile();
lbl-1000:
            // 1 sources

            {
                new DisplayMessage(ResourceLoader.INSTANCE.queryString("FE_WIZARD_TITLEBAR_TEXT"), connectionStatus.getChildren()[0].getException().getLocalizedMessage()).run();
                propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)new FEWizardSelectionProvider(connectionProfile));
                selection = new StructuredSelection((Object)connectionProfile);
                propertyDialogAction.selectionChanged((IStructuredSelection)selection);
                if (propertyDialogAction.isApplicableForSelection()) {
                    dialog = propertyDialogAction.createDialog();
                    initialPage = ((ConnectionProfileProvider)connectionProfile.getProvider()).getPropertiesPersistenceHook().getConnectionPropertiesPageID();
                    if (initialPage != null) {
                        ((IWorkbenchPreferenceContainer)dialog).openPage(initialPage, null);
                    }
                    if (dialog.open() == 1) {
                        return activeConnection;
                    }
                }
                connectionStatus = connectionProfile.connectWithoutJob();
                connection = connectionProfile.getManagedConnection("java.sql.Connection");
lbl25:
                // 2 sources

                ** while (connectionProfile.getConnectionState() != 1)
            }
lbl26:
            // 1 sources

            activeConnection = connection.getConnection().getConnectionProfile();
        }
        return activeConnection;
    }

    public class DisplayMessage
    implements Runnable {
        String title;
        String message;

        public DisplayMessage(String title, String message) {
            this.title = title;
            this.message = message;
        }

        public void run() {
            MessageDialog.openInformation((Shell)FEWizard.this.getShell(), (String)this.title, (String)this.message);
        }
    }

    private class FEWizardSelectionProvider
    implements ISelectionProvider {
        private IStructuredSelection selection;

        public FEWizardSelectionProvider(IConnectionProfile connectionProfile) {
            this.selection = new StructuredSelection((Object)connectionProfile);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

