/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result;

public class ColumnIdentifier {
    private Integer m_pos;
    private String m_nameExpr;
    private static final String LOG_CLASSNAME_PREFIX = "ColumnIdentifier@";
    private static final String LOG_ORDINAL_LABEL = " [ordinal= ";
    private static final String LOG_NAME_LABEL = ", name= ";
    private static final String LOG_END_BRACKET = "]";

    public ColumnIdentifier(int pos, String nameExpr) {
        this(pos);
        this.setNameExpression(nameExpr);
    }

    public ColumnIdentifier(int pos) {
        if (pos < 1) {
            throw new IllegalArgumentException(Integer.valueOf(pos).toString());
        }
        this.m_pos = pos;
    }

    public ColumnIdentifier(String nameExpr) {
        if (nameExpr == null || nameExpr.length() == 0) {
            throw new IllegalArgumentException(nameExpr);
        }
        this.m_nameExpr = nameExpr;
    }

    public void setNumber(Integer pos) {
        this.m_pos = pos;
    }

    public void setNameExpression(String nameExpr) {
        this.m_nameExpr = nameExpr;
    }

    public void setValueExpression(String valueExpr) {
        this.setNameExpression(valueExpr);
    }

    public Integer getNumber() {
        return this.m_pos;
    }

    public String getNameExpression() {
        return this.m_nameExpr;
    }

    public String getValueExpression() {
        return this.getNameExpression();
    }

    public boolean isIdentifiedByNumber() {
        return this.m_pos != null && this.m_pos > 0;
    }

    public boolean hasNameExpression() {
        return this.m_nameExpr != null && this.m_nameExpr.length() > 0;
    }

    public boolean hasValueExpression() {
        return this.hasNameExpression();
    }

    public boolean isValid() {
        if (this.isIdentifiedByNumber()) {
            return true;
        }
        return this.hasNameExpression();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier thatObj = (ColumnIdentifier)obj;
        if (this == thatObj) {
            return true;
        }
        boolean isEqual = false;
        if (this.isIdentifiedByNumber()) {
            if (this.m_pos.equals(thatObj.m_pos)) {
                isEqual = true;
            } else {
                return false;
            }
        }
        if (this.hasNameExpression()) {
            return this.m_nameExpr.equals(thatObj.m_nameExpr);
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.isIdentifiedByNumber()) {
            hashCode = this.m_pos.hashCode();
        }
        if (this.hasNameExpression()) {
            return hashCode ^ this.m_nameExpr.hashCode();
        }
        return hashCode == 0 ? super.hashCode() : hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(LOG_CLASSNAME_PREFIX);
        buffer.append(super.hashCode());
        buffer.append(LOG_ORDINAL_LABEL);
        buffer.append(this.m_pos);
        buffer.append(LOG_NAME_LABEL);
        buffer.append(this.m_nameExpr);
        buffer.append(LOG_END_BRACKET);
        return buffer.toString();
    }
}

