/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.enablement.oda.ws.ui.wizards.WebServiceSelectionPageHelper;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class WebServiceSelectionPage
extends DataSourceWizardPage {
    private static final String HTTPHEAD = "http://";
    private WebServiceSelectionPageHelper pageHelper;
    private Properties wsProperties;

    public WebServiceSelectionPage(String pageName) {
        super(pageName);
    }

    public void createPageCustomControl(Composite parent) {
        if (this.pageHelper == null) {
            this.pageHelper = new WebServiceSelectionPageHelper((WizardPage)this);
        }
        this.pageHelper.createCustomControl(parent);
        this.pageHelper.initCustomControl(this.wsProperties);
    }

    public void setInitialProperties(Properties dataSourceProps) {
        this.wsProperties = dataSourceProps;
        if (this.pageHelper == null) {
            return;
        }
        this.pageHelper.initCustomControl(this.wsProperties);
    }

    public Properties collectCustomProperties() {
        if (this.pageHelper != null) {
            return this.pageHelper.collectCustomProperties(this.wsProperties);
        }
        return this.wsProperties != null ? this.wsProperties : new Properties();
    }

    public void refresh() {
        this.enableAllControls(this.getControl(), this.isSessionEditable());
    }

    protected Runnable createTestConnectionRunnable(final IConnectionProfile profile) {
        return new Runnable(){

            public void run() {
                IConnection conn = PingJob.createTestConnection((IConnectionProfile)profile);
                Throwable exception = PingJob.getTestConnectionException((IConnection)conn);
                if (conn != null) {
                    conn.close();
                }
                if (exception != null) {
                    Properties properties = WebServiceSelectionPage.this.collectCustomProperties();
                    String wsdlUri = (String)properties.get("wsdlURI");
                    if (wsdlUri != null && !wsdlUri.startsWith(WebServiceSelectionPage.HTTPHEAD)) {
                        properties.put("wsdlURI", WebServiceSelectionPage.HTTPHEAD + wsdlUri.trim());
                    }
                    profile.setBaseProperties(properties);
                    conn = PingJob.createTestConnection((IConnectionProfile)profile);
                    if (PingJob.getTestConnectionException((IConnection)conn) == null) {
                        WebServiceSelectionPage.this.pageHelper.setWsdlURIString(WebServiceSelectionPage.HTTPHEAD + wsdlUri.trim());
                        exception = null;
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                PingJob.PingUIJob.showTestConnectionMessage((Shell)WebServiceSelectionPage.this.getShell(), (Throwable)exception);
            }
        };
    }
}

