/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.date;

import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.date.DateFormatFactory;
import org.eclipse.datatools.enablement.oda.xml.util.date.PatternKey;

public class DateFormatISO8601 {
    public static Date parse(String source) throws ParseException, ParseException {
        if (source == null) {
            return null;
        }
        Date resultDate = null;
        SimpleDateFormat simpleDateFormatter = DateFormatFactory.getPatternInstance(PatternKey.getPatterKey(source = DateFormatISO8601.cleanDate(source)));
        if (simpleDateFormatter != null) {
            try {
                resultDate = simpleDateFormatter.parse(source);
                return resultDate;
            }
            catch (ParseException parseException) {}
        }
        if (resultDate == null) {
            throw new ParseException(String.valueOf(Messages.getString("dateFormatISO8601.inconvertibleValueError")) + source, 0);
        }
        return resultDate;
    }

    private static String cleanDate(String s) {
        int zoneIndex;
        if ((s = s.trim()).indexOf(84) < 12) {
            s = s.replaceFirst("T", " ");
        }
        if ((zoneIndex = s.indexOf(90)) >= 0 && zoneIndex == s.length() - 1) {
            return s.substring(0, zoneIndex).trim();
        }
        return s;
    }

    private static int getZoneIndex(String s) {
        int index = s.indexOf(43);
        if (index > 0) {
            return index;
        }
        index = s.indexOf(45);
        if (index <= 0) {
            return index;
        }
        index = s.indexOf(45, index + 1);
        if (index <= 0) {
            return index;
        }
        index = s.indexOf(45, index + 1);
        return index;
    }
}

