/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.cast;

import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.FixedPrecisionDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.cast.CastExpressionWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.cast.DataTypeHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ObjectComboHelper;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class CastBuilderPage
extends WizardPage
implements SelectionListener,
KeyListener {
    protected SQLQueryObject sqlStatement;
    private Composite mainPanel;
    private SQLDomainModel domainModel;
    QueryValueExpression inputSQLExpression;
    QueryValueExpression updatedSQLExpression;
    private static final String asString = "AS";
    private Combo castClauseCombo;
    private ObjectComboHelper castClauseComboHelper;
    private Combo dataTypeClauseCombo;
    private Label firstLabel;
    private Combo scopeClause;
    private Label lengthLabel;
    private Label leftBracket;
    private Text dataTypePrecisionText;
    private Label commaLabel;
    private Text dataTypeScaleText;
    private Label rightBracket;
    private Text previewExpressionText;
    private ValueExpressionCast sqlCast;

    public CastBuilderPage(SQLDomainModel domainModel, SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_CAST_BUILDER_TITLE);
        this.setTitle(Messages._UI_WIZARD_CAST_BUILDER_TITLE);
        this.setDescription(Messages._UI_WIZARD_CAST_BUILDER_HEADING);
        this.setPageComplete(true);
        this.sqlStatement = sqlStatementArg;
        this.inputSQLExpression = sqlExpr;
        this.domainModel = domainModel;
        this.sqlCast = null;
    }

    public void createControl(Composite parent) {
        this.mainPanel = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)this.mainPanel, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqle0500");
        GridLayout mainPanelLayout = new GridLayout();
        this.mainPanel.setLayout((Layout)mainPanelLayout);
        this.mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Composite topPanel = new Composite(this.mainPanel, 0);
        GridLayout topPanelLayout = new GridLayout();
        topPanelLayout.numColumns = 7;
        topPanelLayout.marginWidth = 0;
        topPanelLayout.marginHeight = 0;
        topPanel.setLayout((Layout)topPanelLayout);
        topPanel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        Label castLabel = new Label(topPanel, 2048);
        castLabel.setText("CAST (");
        this.castClauseCombo = new Combo(topPanel, 12);
        this.castClauseComboHelper = new ObjectComboHelper(this.castClauseCombo);
        this.fillCastClauseCombo();
        this.castClauseCombo.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.castClauseCombo.select(0);
        this.castClauseCombo.addSelectionListener((SelectionListener)this);
        this.castClauseCombo.setToolTipText(this.castClauseCombo.getText());
        Label asLabel = new Label(topPanel, 2048);
        asLabel.setText(asString);
        this.dataTypeClauseCombo = new Combo(topPanel, 12);
        this.dataTypeClauseCombo.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.fillDataTypeClauseCombo();
        this.dataTypeClauseCombo.select(0);
        this.dataTypeClauseCombo.addSelectionListener((SelectionListener)this);
        this.dataTypeClauseCombo.setToolTipText(this.dataTypeClauseCombo.getText());
        this.firstLabel = new Label(topPanel, 2048);
        this.firstLabel.setText(")          ");
        Composite lengthPanel = new Composite(this.mainPanel, 0);
        GridLayout lengthPanelLayout = new GridLayout();
        lengthPanelLayout.numColumns = 6;
        lengthPanelLayout.marginWidth = 0;
        lengthPanel.setLayout((Layout)lengthPanelLayout);
        this.lengthLabel = new Label(lengthPanel, 256);
        this.lengthLabel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.lengthLabel.setText(Messages._UI_LABEL_DATATYPE_LENGTH);
        this.leftBracket = new Label(lengthPanel, 2060);
        this.leftBracket.setText("  (  ");
        this.dataTypePrecisionText = new Text(lengthPanel, 2052);
        this.dataTypePrecisionText.setVisible(false);
        this.dataTypePrecisionText.setEnabled(false);
        this.dataTypePrecisionText.addKeyListener((KeyListener)this);
        this.commaLabel = new Label(lengthPanel, 2060);
        this.commaLabel.setText(" ,    ");
        this.commaLabel.setVisible(false);
        this.dataTypeScaleText = new Text(lengthPanel, 2052);
        this.dataTypeScaleText.setVisible(false);
        this.dataTypeScaleText.setEnabled(false);
        this.dataTypeScaleText.addKeyListener((KeyListener)this);
        this.rightBracket = new Label(lengthPanel, 2060);
        this.rightBracket.setText("  )  ");
        this.rightBracket.setVisible(false);
        Label previewLabel = new Label(this.mainPanel, 256);
        previewLabel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        previewLabel.setText(Messages._UI_LABEL_PREVIEW_CAST_EXPRESSION);
        this.previewExpressionText = new Text(this.mainPanel, 2124);
        this.previewExpressionText.setLayoutData((Object)ViewUtility.createFill());
        this.updatePreview();
        this.setControl((Control)this.mainPanel);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.castClauseCombo) {
            this.castClauseCombo.setToolTipText(this.castClauseCombo.getText());
            this.updateExpression();
            this.updatePreview();
        } else if (se.widget == this.dataTypeClauseCombo) {
            this.dataTypeClauseCombo.setToolTipText(this.dataTypeClauseCombo.getText());
            this.updateExpression();
            this.updateLengthPanel();
            this.updatePreview();
        } else if (se.widget == this.scopeClause) {
            this.updatePreview();
        }
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            PredefinedDataType dataType;
            this.fillCastClauseCombo();
            this.fillDataTypeClauseCombo();
            this.dataTypeClauseCombo.select(0);
            this.castClauseCombo.select(0);
            if (this.sqlCast == null) {
                ExpressionHelper eh = new ExpressionHelper();
                this.sqlCast = eh.createCast(null, "");
                dataType = org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper.getPredefinedDataTypeForNamedType((String)this.dataTypeClauseCombo.getText());
                this.sqlCast.setDataType((DataType)dataType);
                this.updateExpression();
            } else if (this.inputSQLExpression != null) {
                this.sqlCast = (ValueExpressionCast)this.inputSQLExpression;
            }
            QueryValueExpression castValExpr = this.sqlCast.getValueExpr();
            if (castValExpr instanceof ValueExpressionNullValue) {
                this.castClauseCombo.select(this.castClauseCombo.indexOf("NULL"));
            }
            if (castValExpr instanceof ValueExpressionVariable) {
                this.castClauseCombo.select(this.castClauseCombo.indexOf("?"));
            }
            if (castValExpr instanceof ValueExpressionColumn) {
                this.castClauseCombo.select(this.castClauseCombo.indexOf(((ValueExpressionColumn)castValExpr).getName()));
                this.castClauseComboHelper.select(((ValueExpressionColumn)castValExpr).getName(), castValExpr);
            }
            dataType = (PredefinedDataType)this.sqlCast.getDataType();
            this.dataTypeClauseCombo.select(this.dataTypeClauseCombo.indexOf(dataType.getPrimitiveType().getName()));
            this.updateExpression();
            this.updatePreview();
            this.updateLengthPanel();
            this.updateFinishButton();
        }
    }

    private void updateFinishButton() {
        boolean isComplete = true;
        this.setPageComplete(isComplete);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setAllPagesComplete(true);
        }
    }

    public boolean performOk() {
        this.updatedSQLExpression = this.sqlCast;
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        } else if (this.getWizard() instanceof CastExpressionWizard) {
            CastExpressionWizard wiz = (CastExpressionWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        }
        return true;
    }

    private void fillCastClauseCombo() {
        this.castClauseCombo.removeAll();
        Vector<LabelValuePair> availableExpressionsComboBoxItemsVector = new Vector<LabelValuePair>();
        Vector availableExpressionsVector = new Vector();
        if (this.sqlStatement != null) {
            availableExpressionsVector.addAll(BuilderUtility.getColumnVector(this.sqlStatement));
        } else {
            availableExpressionsVector = new Vector();
        }
        int i = 0;
        while (i < availableExpressionsVector.size()) {
            if (availableExpressionsVector.elementAt(i) instanceof QueryValueExpression) {
                availableExpressionsComboBoxItemsVector.addElement(new LabelValuePair(((QueryValueExpression)availableExpressionsVector.elementAt(i)).getSQL(), availableExpressionsVector.elementAt(i)));
            } else {
                availableExpressionsComboBoxItemsVector.addElement(new LabelValuePair(availableExpressionsVector.elementAt(i).toString(), availableExpressionsVector.elementAt(i)));
            }
            ++i;
        }
        availableExpressionsComboBoxItemsVector.addElement(new LabelValuePair("NULL", null));
        availableExpressionsComboBoxItemsVector.addElement(new LabelValuePair("?", null));
        Object[] expressionsArray = new LabelValuePair[availableExpressionsComboBoxItemsVector.size()];
        availableExpressionsComboBoxItemsVector.copyInto(expressionsArray);
        this.castClauseComboHelper.setItems((LabelValuePair[])expressionsArray);
    }

    private void updateLengthPanel() {
        this.lengthLabel.setText(Messages._UI_LABEL_DATATYPE_LENGTH);
        this.leftBracket.setVisible(true);
        this.leftBracket.setText("  -  ");
        if (this.domainModel.getVendor().isDB2()) {
            if (this.dataTypeClauseCombo.getText().equals("DECIMAL") || this.dataTypeClauseCombo.getText().equals("NUMERIC")) {
                this.leftBracket.setText("  (  ");
                this.leftBracket.setVisible(true);
                this.dataTypePrecisionText.setVisible(true);
                this.dataTypePrecisionText.setEnabled(true);
                this.commaLabel.setText(" ,    ");
                this.commaLabel.setVisible(true);
                this.dataTypeScaleText.setVisible(true);
                this.dataTypeScaleText.setEnabled(true);
                this.rightBracket.setText("  )  ");
                this.rightBracket.setVisible(true);
            } else if (this.dataTypeClauseCombo.getText().equals("CHAR") || this.dataTypeClauseCombo.getText().equals("VARCHAR") || this.dataTypeClauseCombo.getText().equals("LONG VARCHAR") || this.dataTypeClauseCombo.getText().equals("CLOB") || this.dataTypeClauseCombo.getText().equals("GRAPHIC") || this.dataTypeClauseCombo.getText().equals("VARGRAPHIC") || this.dataTypeClauseCombo.getText().equals("LONG VARGRAPHIC") || this.dataTypeClauseCombo.getText().equals("DBCLOB") || this.dataTypeClauseCombo.getText().equals("BLOB")) {
                this.leftBracket.setText("  (  ");
                this.leftBracket.setVisible(true);
                this.dataTypePrecisionText.setVisible(true);
                this.dataTypePrecisionText.setEnabled(true);
                this.commaLabel.setText("  )  ");
                this.commaLabel.setVisible(true);
                this.dataTypeScaleText.setVisible(false);
                this.dataTypeScaleText.setEnabled(false);
                this.dataTypeScaleText.setText("");
                this.rightBracket.setVisible(false);
            } else {
                this.leftBracket.setVisible(true);
                this.leftBracket.setText("  -  ");
                this.dataTypePrecisionText.setVisible(false);
                this.dataTypePrecisionText.setEnabled(false);
                this.dataTypePrecisionText.setText("");
                this.commaLabel.setVisible(false);
                this.dataTypeScaleText.setVisible(false);
                this.dataTypeScaleText.setEnabled(false);
                this.dataTypeScaleText.setText("");
                this.rightBracket.setVisible(false);
            }
        }
    }

    private void fillDataTypeClauseCombo() {
        this.dataTypeClauseCombo.removeAll();
        if (this.domainModel.getVendor().isOracle()) {
            this.dataTypeClauseCombo.setItems(DataTypeHelper.oracleDataTypes);
        } else if (this.domainModel.getVendor().isMySQL()) {
            this.dataTypeClauseCombo.setItems(DataTypeHelper.mySQLDataTypes);
        } else if (this.domainModel.getVendor().isSybase()) {
            this.dataTypeClauseCombo.setItems(DataTypeHelper.sybaseDataTypes);
        } else if (this.domainModel.getVendor().isCloudscape()) {
            this.dataTypeClauseCombo.setItems(DataTypeHelper.cloudscapeDataTypes);
        } else {
            this.dataTypeClauseCombo.setItems(DataTypeHelper.db2DataTypes);
        }
    }

    private void updatePreview() {
        if (this.sqlCast != null) {
            this.previewExpressionText.setText(this.sqlCast.getSQL().trim());
        }
    }

    private void updateExpression() {
        String castClauseString = this.castClauseCombo.getText();
        if (castClauseString.equals("NULL")) {
            SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
            ValueExpressionNullValue nullExpr = factory.createValueExpressionNullValue();
            this.sqlCast.setValueExpr((QueryValueExpression)nullExpr);
        } else if (castClauseString.equals("?")) {
            SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
            ValueExpressionVariable varExpr = factory.createValueExpressionVariable();
            varExpr.setName("?");
            this.sqlCast.setValueExpr((QueryValueExpression)varExpr);
        } else {
            int index = this.castClauseCombo.getSelectionIndex();
            QueryValueExpression valExpr = (QueryValueExpression)this.castClauseComboHelper.getObjectAt(index);
            ValueExpressionColumn newValExpr = ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)valExpr);
            this.sqlCast.setValueExpr((QueryValueExpression)newValExpr);
        }
        PredefinedDataType dataType = org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper.getPredefinedDataTypeForNamedType((String)this.dataTypeClauseCombo.getText());
        if (this.dataTypePrecisionText.getText().length() > 0) {
            int dataTypeLength = 0;
            int dataTypeScale = 0;
            try {
                dataTypeLength = Integer.parseInt(this.dataTypePrecisionText.getText());
            }
            catch (Exception exception) {
                dataTypeLength = 0;
            }
            if (dataTypeLength <= 0) {
                dataTypeLength = 0;
            }
            try {
                dataTypeScale = Integer.parseInt(this.dataTypeScaleText.getText());
            }
            catch (Exception exception) {
                dataTypeScale = 0;
            }
            if (dataTypeScale <= 0) {
                dataTypeScale = 0;
            }
            if (dataTypeLength > 0 || dataTypeScale > 0) {
                if (dataType instanceof BinaryStringDataType) {
                    ((BinaryStringDataType)dataType).setLength(dataTypeLength);
                } else if (dataType instanceof CharacterStringDataType) {
                    ((CharacterStringDataType)dataType).setLength(dataTypeLength);
                } else if (dataType instanceof FixedPrecisionDataType && (this.dataTypeClauseCombo.getText().equals("DECIMAL") || this.dataTypeClauseCombo.getText().equals("NUMERIC"))) {
                    ((FixedPrecisionDataType)dataType).setPrecision(dataTypeLength);
                    ((FixedPrecisionDataType)dataType).setScale(dataTypeScale);
                }
            }
        }
        this.sqlCast.setDataType((DataType)dataType);
    }

    public boolean currentPage() {
        return this.isCurrentPage();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.updateExpression();
        this.updatePreview();
    }
}

